/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.xunit;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.xunit.XUnitReportXmlImporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class XUnitTestTool
extends BaseTestTool {
    public String getName() {
        return "xUnit";
    }

    public String getCategory() {
        return "functional";
    }

    public Collection<OverthereFile> findTestResultPaths(FileMatcher pattern) {
        Collection testResultFiles = super.findTestResultPaths(pattern);
        HashSet<OverthereFile> testResultDirectories = new HashSet<OverthereFile>();
        for (OverthereFile resultFile : testResultFiles) {
            testResultDirectories.add(resultFile.getParentFile());
        }
        return testResultDirectories;
    }

    public List<Importable> findImportables(OverthereFile searchPath, FileMatcher fileMatcher) {
        Collection testResultFiles = this.globbit(searchPath, fileMatcher);
        ArrayList<Importable> importables = new ArrayList<Importable>();
        for (OverthereFile testResult : testResultFiles) {
            String moduleName = XUnitTestTool.moduleName(searchPath, testResult);
            importables.add(new XUnitReportXmlImporter(moduleName, testResult));
        }
        return importables;
    }

    public String getSearchPattern() {
        return "**/TEST-*.xml";
    }

    public static String moduleName(OverthereFile searchPath, OverthereFile resultsPath) {
        if (resultsPath == null) {
            return null;
        }
        if (searchPath.equals(resultsPath.getParentFile())) {
            return resultsPath.getName();
        }
        return XUnitTestTool.moduleName(searchPath, resultsPath.getParentFile());
    }
}

