set -e

echo "Uninstallation of XL Deploy"

INSTALL_DIR="${previousDeployed.container.installationHome}"
XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
LINKED_XLD_HOME=$INSTALL_DIR/xl-deploy-current

if [ ! -d "$XLD_HOME" ]; then
  echo "Directory $XLD_HOME which is supposed to contain server installation does not exist."
  exit 1
fi

$LINKED_XLD_HOME/bin/${previousDeployed.container.uninstallerExecutableName}

rm -rf $XLD_HOME
rm -rf $LINKED_XLD_HOME

echo "Uninstall Repository"
REPO_DIR=$(find "$INSTALL_DIR/data" -type d -name 'xld-ci-explorer-*-repository' | head -1)
DEST_DIR="$INSTALL_DIR/derby-repository"
echo "Uninstalling XL Deploy Repository from $REPO_DIR and $DEST_DIR"
rm -rf $REPO_DIR $DEST_DIR
echo "SUCCESS"
