set -e

INSTALL_DIR="${deployed.container.installationHome}"
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -o "${deployed.file.path}" -d $DATA_DIR

XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
CONF_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-configuration' | head -1)
DEST_DIR="$XLD_HOME/conf"

XL_DEPLOY_CONF_FILE=$XLD_HOME/conf/xl-deploy.conf

if [ ! -z $CONF_DIR ] && [ -d $CONF_DIR ]; then
echo "Installing XL Deploy Config Data from $CONF_DIR into $DEST_DIR"
cp -rf $CONF_DIR/* $DEST_DIR

echo "Injecting Database configuration..."
DB_STRING="jdbc:derby://localhost:1527/xldrepo;create=true;user=admin;password=admin"
echo "xl.reporting.database.db-url=\"$DB_STRING\"" >> $XL_DEPLOY_CONF_FILE
echo "xl.repository.database.db-url=\"$DB_STRING\"" >> $XL_DEPLOY_CONF_FILE
fi

echo "SUCCESS"