set -e

INSTALL_DIR="${deployed.container.installationHome}"
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -o "${deployed.file.path}" -d $DATA_DIR

XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
EXT_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-extensions' | head -1)
DEST_DIR="$XLD_HOME/ext"

if [ ! -z $EXT_DIR ] && [ -d $EXT_DIR ]; then
    echo "Installing XL Deploy Extensions Data from $EXT_DIR into $DEST_DIR"
    cp -rf $EXT_DIR/* $DEST_DIR
fi

echo "SUCCESS"