set -e

echo "Updating XLD ${deployed.file.name}"

INSTALL_DIR="${deployed.container.installationHome}"
PREVIOUS_XLD_HOME=$INSTALL_DIR/`basename ${previousDeployed.file.name} .zip`
NEW_XLD_HOME=$INSTALL_DIR/`basename ${deployed.file.name} .zip`
LINKED_XLD_HOME=$INSTALL_DIR/xl-deploy-current
MIGRATOR_LOCATION="$INSTALL_DIR/jcr-to-sql-migrator.zip"

echo "Uninstalling ${previousDeployed.file.name}"
$PREVIOUS_XLD_HOME/bin/${previousDeployed.container.uninstallerExecutableName}

unzip -qo "${deployed.file.path}" -d $INSTALL_DIR

rm $LINKED_XLD_HOME
ln -sf $NEW_XLD_HOME $LINKED_XLD_HOME

echo "Updating XL Deploy server in $NEW_XLD_HOME with $PREVIOUS_XLD_HOME"

cp -rf $PREVIOUS_XLD_HOME/ext $LINKED_XLD_HOME/
cp -rf $PREVIOUS_XLD_HOME/conf $LINKED_XLD_HOME/

#INSTALLING CONFIGURATION

for conf in $INSTALL_DIR/conf/*; do
    if [ -f $conf ]; then
        echo "Installing configuration $conf"
        cp -rfv $conf $LINKED_XLD_HOME/conf/
    fi
done

echo "Remove deprecated config files ${deployed.deprecatedConfigFiles}"
DEPRECATED_CONFIG_FILES="${deployed.deprecatedConfigFiles}"

for conf in $DEPRECATED_CONFIG_FILES; do
  if [[ -f $LINKED_XLD_HOME/conf/$conf ]]; then
    echo "Remove deprecated $conf file."
    rm $LINKED_XLD_HOME/conf/$conf
  fi
done

#INSTLLING PLUGINS
for plugin in $INSTALL_DIR/plugins/*; do
    if [ -f $plugin ]; then
        echo "Installing plugin $plugin"
        cp -fv $plugin $LINKED_XLD_HOME/plugins/
    fi
done

echo "Keeping repository ${deployed.keepRepository}"

if [ "${deployed.keepRepository}" == "yes" ]; then
    echo "Copying XLD repository from previous version"
    cp -rf $PREVIOUS_XLD_HOME/repository $LINKED_XLD_HOME/

    echo "Need Migrator ${previousDeployed.needMigrator}"
    if [ -f "$MIGRATOR_LOCATION" ] && [ "${previousDeployed.needMigrator}" == "yes" ]; then
        echo "Installing JCR to SQL Migrator"
        unzip -o $MIGRATOR_LOCATION -d $LINKED_XLD_HOME
    fi

    timeout --preserve-status 90 bash -c "$LINKED_XLD_HOME/bin/run.sh -force-upgrades" || true
fi

echo "Installing XLD as a service"

yes root | $LINKED_XLD_HOME/bin/${deployed.container.installerExecutableName}

rm -rf $PREVIOUS_XLD_HOME

service xl-deploy stop

echo "SUCCESS"
