set -e

if [ "${deployed.generatedata}" == "yes" ]; then

    echo "Generating Data as it is set to ${deployed.generatedata}"
    INSTALL_DIR="${deployed.container.installationHome}"
    REPO_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-repository' | head -1)
    DEST_DIR="$INSTALL_DIR/derby-repository/xldrepo"
    mkdir -p $DEST_DIR

    echo "Installing XL Deploy Repository into $DEST_DIR"
    unzip -o "${deployed.file.path}" -d $DEST_DIR
    echo "Starting derby database"
    nohup service derby start

    echo "SUCCESS"

else

    echo "Skipping Generating Data as it is set to ${deployed.generatedata}"

fi