angular.module('CompareApp')
    .factory('TaskService', function (xmlHttp, xJsonHttp, xlDeployServicesRoot, xlExtApiServicesRoot) {
        return {
            failedTaskStates : ['FAILING', 'FAILED', 'STOPPING', 'STOPPED'],

            startTask: function (taskId) {
                return xmlHttp.post(xlDeployServicesRoot + 'task/' + taskId + '/start');
            },
            getTaskStepLog: function(taskId, stepId) {
                return xmlHttp.get(xlDeployServicesRoot + 'task/' + taskId + '/step/' + stepId);
            },
            getTask: function (taskId, params) {
                return xmlHttp.get(xlDeployServicesRoot + 'task/' + taskId, {'params': params});
            },
            archiveTask: function (taskId) {
                return xmlHttp.post(xlDeployServicesRoot + 'task/' + taskId + '/archive');
            },
            abortTask: function (taskId) {
                return xJsonHttp.get(xlExtApiServicesRoot + 'compare-plugin/abort-task', {"params": {"taskId": taskId}});
            }
        };
    });