angular.module('CompareApp').filter('orderByPartialCiName', function () {

    function getCiNameHeader(ciId) {
        if (ciId == "/") return ciId;

        var index = ciId.lastIndexOf("/");
        return index == -1 ? ciId : ciId.substring(index + 1);
    }

    return function (ciIds) {
        var r = [];
        _.each(ciIds, function (ciId) {
            var key = getCiNameHeader(ciId.key);
            r.push({"key" : key, "value" : ciId});
        });

        return _.pluck(_.sortBy(r, 'key'), 'value');
    };
});
