import time

class TaskKiller(object):
    def __init__(self, task_service):
        self._task_service = task_service

    def _task_state(self, task_id):
        task = self._task_service.getTask(task_id)
        return task.state.name()

    def _wait_for_stable_state(self, task_id):
        non_executing_states = ['DONE', 'EXECUTED', 'STOPPED', 'FAILED', 'ABORTED']

        task_state = self._task_state(task_id)
        while task_state not in non_executing_states:
            logger.info('waiting for task to be in stable state... ')
            time.sleep(1)
            task_state = self._task_state(task_id)

        if task_state == 'EXECUTED':
            logger.info('task executed, will be archived')
            self._task_service.archive(task_id)

        elif task_state in ['STOPPED', 'FAILED', 'ABORTED']:
            logger.info('task stopped/failed/aborted, will be cancelled')
            self._task_service.cancel(task_id)

    def abort(self, task_id):
        task_state = self._task_state(task_id)
        logger.info('state :', task_state)

        #task not started yet, simply cancel it
        if task_state in ['PENDING', 'SCHEDULED', 'QUEUED']:
            self._task_service.cancel(task_id)
            return

        #abort if task is executing
        if task_state == 'EXECUTING':
            try:
                # small window of error here. task might have just finished successfully before abort is called
                logger.info('aborting task', task_id)
                self._task_service.abort(task_id)
            except:
                self.abort(task_id)

        # otherwise wait for it to be in a non-executing state
        self._wait_for_stable_state(task_id)

