/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.maven.ArtifactRepository;
import com.xebialabs.deployit.maven.Deployable;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class MavenDeployable
extends Deployable {
    protected String name;
    protected String type;
    protected File location;
    @Deprecated
    protected String entryName;
    protected final Map<String, Object> values = new HashMap<String, Object>();
    protected List<String> tags = new ArrayList<String>();
    private String groupId;
    private String artifactId;
    private String classifier;
    private String artifactType;
    private MavenProject project;
    private ArtifactRepository artifactRepository;

    public MavenDeployable() {
    }

    public MavenDeployable(String name, String type) {
        this(name, type, null);
    }

    public MavenDeployable(String name, String type, File location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addValue(String name, Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value, (Object)String.format("null value for %s", name));
        try {
            if ("location".equals(name)) {
                this.setLocation(new File((String)value));
            } else {
                Field declaredField = this.getField(name);
                declaredField.set(this, value);
            }
        }
        catch (NoSuchFieldException e) {
            this.values.put(name, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Cannot set %s value on field %s", name, value), e);
        }
    }

    private Field getField(String name) throws NoSuchFieldException {
        try {
            return MavenDeployable.class.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            return MavenDeployable.class.getDeclaredField(name);
        }
    }

    public String getName() {
        return Strings.isNullOrEmpty((String)this.name) ? this.artifactId : this.name;
    }

    public File getLocation() {
        if (this.location != null) {
            if (this.location.isAbsolute()) {
                return this.location;
            }
            return new File(this.project.getBasedir(), this.location.getPath());
        }
        if (this.isMavenArtifact()) {
            Artifact artifact = this.getArtifactRepository().findSingleArtifact(Strings.isNullOrEmpty((String)this.groupId) ? this.project.getGroupId() : this.groupId, this.artifactId, this.artifactType, this.classifier);
            File file = artifact.getFile();
            if (file == null) {
                throw new IllegalStateException(String.format("Associated file of %s is empty", artifact));
            }
            return file;
        }
        return null;
    }

    public boolean hasProperty(String propertyName) {
        Set<String> propertyNames = this.getValues().keySet();
        return propertyNames.contains(propertyName);
    }

    public Object getProperty(String name) {
        return this.getValues().get(name);
    }

    private boolean isMavenArtifact() {
        return !Strings.isNullOrEmpty((String)this.groupId) || !Strings.isNullOrEmpty((String)this.artifactId);
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    private ArtifactRepository getArtifactRepository() {
        if (this.project != null && this.artifactRepository == null) {
            this.artifactRepository = new ArtifactRepository(this.project);
        }
        return this.artifactRepository;
    }

    public String toString() {
        return "MavenDeployable{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', classifier='" + this.classifier + "', artifactType='" + this.artifactType + "'} " + super.toString();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public static class CiRefProperty {
        private String ref;

        public CiRefProperty(String ref) {
            this.ref = ref;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

