/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.maven.MavenDeployable;
import com.xebialabs.deployit.maven.XmlFragment;
import com.xebialabs.deployit.maven.converter.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.StAXStreamBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class MavenDarPackager {
    public static final String BUILD_PACKAGE_VERSION = "build.dar.package.version";
    private static final String FILE_URI_PROPERTY = "fileUri";
    private static final String APP_LOCATION = "location";
    private final Log log;
    private final List<MavenDeployable> deployables = Lists.newArrayList();
    private final List<XmlFragment> properties = Lists.newArrayList();
    private MavenProject project;
    private final List<MavenProject> reactorProjects;
    private final String packageVersion;
    private final String applicationName;
    private final boolean timestampedVersion;

    public MavenDarPackager(MavenProject project, List<MavenProject> reactorProjects, String applicationName, boolean timestampedVersion, Log log, String packageVersion) {
        this.project = project;
        this.reactorProjects = reactorProjects;
        this.packageVersion = packageVersion;
        this.applicationName = Strings.isNullOrEmpty((String)applicationName) ? project.getArtifactId() : applicationName;
        this.timestampedVersion = timestampedVersion;
        this.log = log;
    }

    public void addProperties(List<XmlFragment> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties.addAll(properties);
        }
    }

    public void addDeployables(Collection<? extends MavenDeployable> deployables) {
        this.deployables.addAll(deployables);
    }

    public File perform() {
        File targetDir = new File(this.project.getBuild().getDirectory());
        File darFile = new File(targetDir, String.format("%s-%s.dar", this.project.getArtifactId(), this.project.getVersion()));
        if (darFile.exists()) {
            return darFile;
        }
        File workingDirectory = this.createWorkingDirectory(targetDir);
        this.log.debug((CharSequence)(" prepare exploded dar in working directory " + String.valueOf(workingDirectory)));
        this.generateExplodedDar(workingDirectory);
        this.log.debug((CharSequence)(" create the jar " + String.valueOf(darFile)));
        Files.jar(darFile, workingDirectory);
        return darFile;
    }

    private void generateExplodedDar(File workingDirectory) {
        Element manifestElm = new Element("udm.DeploymentPackage");
        manifestElm.setAttribute("version", this.getCIVersion(this.project, this.timestampedVersion, this.packageVersion));
        manifestElm.setAttribute("application", this.applicationName);
        List<Content> propertyElms = this.marshallProperties();
        if (!propertyElms.isEmpty()) {
            manifestElm.addContent(propertyElms);
        }
        Element deployablesElm = new Element("deployables");
        for (MavenDeployable deployable : this.deployables) {
            deployablesElm.addContent(this.marshallDeployable(deployable, workingDirectory));
        }
        manifestElm.addContent((Content)deployablesElm);
        this.writeManifest(manifestElm, workingDirectory);
    }

    private List<Content> marshallProperties() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        ArrayList contents = Lists.newArrayList();
        StAXStreamBuilder builder = new StAXStreamBuilder();
        for (XmlFragment property : this.properties) {
            try {
                XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(new StringReader(property.getFragment()));
                xmlStreamReader.next();
                Content fragment = builder.fragment(xmlStreamReader);
                contents.add(fragment);
            }
            catch (JDOMException e) {
                throw new RuntimeException(e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        return contents;
    }

    private Content marshallDeployable(MavenDeployable deployable, File workingDirectory) {
        String fileUriProperty;
        Element deployableElm = new Element(deployable.getType());
        if (null == deployable.getName()) {
            throw new IllegalArgumentException(String.format("Deployable of type %s must have name", deployable.getType()));
        }
        deployableElm.setAttribute("name", deployable.getName());
        if (deployable.hasProperty("LocationElement") || deployable.hasProperty("libertyAppLocation")) {
            String locationValue = "";
            locationValue = deployable.hasProperty("LocationElement") ? deployable.getProperty("LocationElement").toString() : deployable.getProperty("libertyAppLocation").toString();
            Element propElm2 = new Element(APP_LOCATION);
            ArrayList contentElms2 = Lists.newArrayList();
            contentElms2.add(new Text(locationValue));
            propElm2.addContent((Collection)contentElms2);
            deployableElm.addContent((Content)propElm2);
        }
        boolean hasFileUriPropertySet = false;
        if (deployable.hasProperty(FILE_URI_PROPERTY) && !Strings.isNullOrEmpty((String)(fileUriProperty = (String)deployable.getProperty(FILE_URI_PROPERTY)))) {
            hasFileUriPropertySet = true;
        }
        if (!hasFileUriPropertySet && deployable.getLocation() != null) {
            String relFilePath = this.stageArtifact(deployable, workingDirectory);
            deployableElm.setAttribute("file", relFilePath);
        }
        Map<String, Object> values = deployable.getValues();
        Set<String> propertyNames = values.keySet();
        for (String name : propertyNames) {
            if (name.equalsIgnoreCase("LocationElement") || name.equalsIgnoreCase("libertyAppLocation")) continue;
            Element propElm = new Element(name);
            List<Object> contentElms = Lists.newArrayList();
            Object value = values.get(name);
            if (value instanceof List) {
                contentElms = this.marshallListValues((List)value, workingDirectory);
            } else if (value instanceof MavenDeployable.CiRefProperty) {
                propElm.setAttribute("ref", ((MavenDeployable.CiRefProperty)value).getRef());
            } else if (value instanceof Map) {
                contentElms = this.marshallMapEntries((Map)value);
            } else if (value instanceof MavenDeployable) {
                contentElms.add(this.marshallDeployable((MavenDeployable)value, workingDirectory));
            } else {
                contentElms.add(new Text((String)value));
            }
            propElm.addContent((Collection)contentElms);
            deployableElm.addContent((Content)propElm);
        }
        if (!deployable.getTags().isEmpty()) {
            Element propElm = new Element("tags");
            propElm.addContent(this.marshallListValues(deployable.getTags(), workingDirectory));
            deployableElm.addContent((Content)propElm);
        }
        return deployableElm;
    }

    private String stageArtifact(MavenDeployable deployable, File workingDirectory) {
        File location = deployable.getLocation();
        File artifactWorkingDirectory = new File(workingDirectory, deployable.getName());
        artifactWorkingDirectory.mkdir();
        if (location.isFile()) {
            this.log.debug((CharSequence)String.format(" copy file %s to %s", location, artifactWorkingDirectory));
            Files.copyFileTo(location, artifactWorkingDirectory);
        } else {
            this.log.debug((CharSequence)String.format(" copy dir  %s to %s", location, artifactWorkingDirectory));
            Files.copyDirectoryTo(location, artifactWorkingDirectory);
        }
        return deployable.getName() + "/" + location.getName();
    }

    private List<Content> marshallMapEntries(Map<String, String> map) {
        ArrayList elms = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element elm = new Element("entry");
            elm.setAttribute("key", entry.getKey());
            elm.addContent((Content)new Text(entry.getValue()));
            elms.add(elm);
        }
        return elms;
    }

    private List<Content> marshallListValues(List<?> list, File workingDirectory) {
        ArrayList elms = Lists.newArrayList();
        for (Object o : list) {
            if (o instanceof MavenDeployable.CiRefProperty) {
                Element ciRefElm = new Element("ci");
                ciRefElm.setAttribute("ref", ((MavenDeployable.CiRefProperty)o).getRef());
                elms.add(ciRefElm);
                continue;
            }
            if (o instanceof MavenDeployable) {
                ((MavenDeployable)o).setProject(this.project);
                elms.add(this.marshallDeployable((MavenDeployable)o, workingDirectory));
                continue;
            }
            Element valueElm = new Element("value");
            valueElm.addContent((Content)new Text((String)o));
            elms.add(valueElm);
        }
        return elms;
    }

    private File createWorkingDirectory(File targetDir) {
        File workingDirectory = new File(targetDir, "deployit-working-dir");
        if (workingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)workingDirectory);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        workingDirectory.mkdirs();
        return workingDirectory;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest(Element manifestElm, File workingDirectory) {
        FileOutputStream outputStream = null;
        try {
            File manifest = new File(workingDirectory, "deployit-manifest.xml");
            this.log.info((CharSequence)("Generate manifest file " + manifest.getAbsolutePath()));
            outputStream = new FileOutputStream(manifest);
            XMLOutputter xmlOutput = new XMLOutputter(Format.getPrettyFormat());
            Document doc = new Document(manifestElm);
            this.log.debug((CharSequence)xmlOutput.outputString(doc));
            xmlOutput.output(doc, (OutputStream)outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException("generation of the manifest file failed", e2);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(outputStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)outputStream);
    }

    private String getCIVersion(MavenProject project, boolean timestampedVersion, String packageVersion) {
        Object ciVersion = project.getVersion();
        if (!Strings.isNullOrEmpty((String)packageVersion)) {
            ciVersion = packageVersion;
        } else if (timestampedVersion) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
            ciVersion = project.getVersion() + "-" + dateFormat.format(System.currentTimeMillis());
            ciVersion = ((String)ciVersion).replace("-SNAPSHOT", "");
        }
        project.getProperties().setProperty(BUILD_PACKAGE_VERSION, (String)ciVersion);
        if (this.reactorProjects != null) {
            for (MavenProject reactorProject : this.reactorProjects) {
                if (reactorProject == project) continue;
                reactorProject.getProperties().setProperty(BUILD_PACKAGE_VERSION, (String)ciVersion);
            }
        }
        this.log.debug((CharSequence)String.format("Project property [%s] set to value [%s]", BUILD_PACKAGE_VERSION, ciVersion));
        return ciVersion;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

