/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.maven.AbstractDeployitMojo;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class CleanMojo
extends AbstractDeployitMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"xldeploy:clean");
        this.boot();
        try {
            DeploymentService deploymentService = this.communicator.getProxies().getDeploymentService();
            String applicationName = this.getPackager().getApplicationName();
            String applicationId = this.getDeployedApplicationId(applicationName);
            Deployment undeployment = deploymentService.prepareUndeploy(this.environmentId + "/" + applicationId);
            String task = deploymentService.createTask(undeployment);
            this.getDeploymentHelper().executeAndArchiveTask(task);
            this.getLog().info((CharSequence)"end of xldeploy:clean.");
        }
        finally {
            this.shutdown();
        }
    }

    private String getDeployedApplicationId(String applicationName) {
        ArrayList segments = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)applicationName));
        int index = segments.size() - 1;
        String deployedApplication = (String)segments.get(index);
        return deployedApplication;
    }
}

