package com.xebialabs.deployit.maven.helper;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;

public class ServerVersionCompatibility {
    private DeployitCommunicator communicator;
    private List<Artifact> pluginArtifacts;

    public ServerVersionCompatibility(DeployitCommunicator communicator, List<Artifact> pluginArtifacts) {
        this.communicator = communicator;
        this.pluginArtifacts = pluginArtifacts;
    }

    /**
     * Verify we're using compatible versions of client.
     * Major version number shoud be equal or greater than server in order to be compatible.
     */
    public void check() {
        String serverVersion = getServerVersion();
        VersionHelper serverVersionHelper = new VersionHelper(serverVersion);
        String serverMajor = serverVersionHelper.getMajor();
        String serverMinor = serverVersionHelper.getMinor();

        String apiVersion = getRemoteApiVersion();
        VersionHelper apiVersionHelper = new VersionHelper(apiVersion);
        String apiMajor = apiVersionHelper.getMajor();
        String apiMinor = apiVersionHelper.getMinor();

        boolean engineApiLessThanServer = StringUtils.isEmpty(apiMajor) || StringUtils.isEmpty(serverMajor) || Integer.valueOf(apiMajor) < Integer.valueOf(serverMajor);
        if ( engineApiLessThanServer) {
            String msg = String.format("Maven plugin engine-api version: '%s' is incompatible with server version: '%s'. Please use correct version of maven plugin.", apiVersion, serverVersion);
            throw new IllegalStateException(msg);
        }
    }

    private String getServerVersion() {
        ServerService serverService = communicator.getProxies().getServerService();
        ServerInfo serverInfo = serverService.getInfo();
        String serverVersion = serverInfo.getVersion();
        return serverVersion;
    }

    private String getRemoteApiVersion() {
        String version = "";
        for (Artifact artifact : pluginArtifacts) {
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            if (groupId.startsWith("com.xebialabs.") && "engine-api".equals(artifactId)) {
                version = artifact.getVersion();
            }
        }
        return version;
    }
}

class VersionHelper {

    private String minor = "";
    private String major = "";

    public VersionHelper(String version) {
        String[] vals = version.split("\\.", 3);
        if (vals.length > 0) {
            major = vals[0];
        }
        if (vals.length > 1) {
            minor = vals[1];
        }
    }

    public String getMajor() {
        return major;
    }

    public String getMinor() {
        return minor;
    }
}
