/*
 * This file is part of Maven Deployit plugin.
 *
 * Maven Deployit plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Maven Deployit plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Maven Deployit plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.xebialabs.deployit.maven;

import java.util.ArrayList;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.dto.Deployment;

/**
 * Clean (Undeploy) the target environment.
 *
 * @author Benoit Moussaud
 * @goal clean
 * @phase post-integration-test
 * @configurator override
 */
public class CleanMojo extends AbstractDeployitMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        getLog().info("xldeploy:clean");
        boot();

        try {
            DeploymentService deploymentService = communicator.getProxies().getDeploymentService();

            // since packager creates name of the application we should use it to retrieve name from it also
            String applicationName = getPackager().getApplicationName();
            String applicationId = getDeployedApplicationId(applicationName);
            Deployment undeployment = deploymentService.prepareUndeploy(environmentId + "/" + applicationId);
            String task = deploymentService.createTask(undeployment);

            getDeploymentHelper().executeAndArchiveTask(task);

            getLog().info("end of xldeploy:clean.");
        } finally {
            shutdown();
        }
    }

    private String getDeployedApplicationId(String applicationName) {
        ArrayList<String> segments = Lists.newArrayList(Splitter.on("/").split(applicationName));
        int index = segments.size() - 1;
        String deployedApplication = segments.get(index);
        return deployedApplication;
    }

}
