/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.scripting.Launch;
import com.xebialabs.impact.wave.scripting.PluginInterface;
import com.xebialabs.impact.wave.scripting.Probe;
import com.xebialabs.impact.wave.scripting.Watcher;
import com.xebialabs.impact.wave.scripting.engine.Handler;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.engine.SerializedObjectWrapper;
import com.xebialabs.impact.wave.scripting.http.WaveRun;
import com.xebialabs.impact.wave.scripting.sandbox.Persistency;
import groovy.lang.GroovyShell;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sandbox {
    private static final Logger logger = LoggerFactory.getLogger(Sandbox.class);
    private final IngestionApiAsync ingestionApi;
    private GroovyShell groovyShell;
    private final File folder;
    private final ObjectMapper objectMapper;
    private final WaveSystem waveSystem;
    private final Map<String, Set<String>> handlersComingFromFile = new HashMap<String, Set<String>>();
    private final Map<String, Set<File>> directoriesByMappedTypes = new HashMap<String, Set<File>>();
    private final Map<File, Set<String>> typesByFolder = new HashMap<File, Set<String>>();
    private final Map<String, String> folderLocks = new ConcurrentHashMap<String, String>();
    private Map<Integer, Tuple2<String, Integer>> fileLineMap = new HashMap<Integer, Tuple2<String, Integer>>();

    public Sandbox(File folder, ObjectMapper objectMapper, WaveSystem waveSystem, IngestionApiAsync ingestionApi) {
        this.waveSystem = waveSystem;
        this.folder = folder;
        this.objectMapper = objectMapper;
        this.ingestionApi = ingestionApi;
    }

    public void start() {
        this.folder.mkdirs();
        this.update(Collections.emptyList());
        Watcher.watch(this.folder, this::update);
    }

    public void update(Collection<File> files) {
        try {
            this.updateScript();
            try {
                HashSet<File> toUpdate = new HashSet<File>();
                Files.walk(this.folder.toPath(), new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".json") && !path.toAbsolutePath().toString().contains("/-")).forEach(path -> toUpdate.add(path.getParent().toFile()));
                this.updateFolders(toUpdate);
            }
            catch (IOException e) {
                logger.error("IOException: {}", (Throwable)e);
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateScript() {
        StringBuilder allScripts = new StringBuilder("import com.xebialabs.impact.wave.scripting.PluginInterface\n");
        int shift = this.countLines(allScripts);
        Class<PluginInterface> clazz = PluginInterface.class;
        synchronized (PluginInterface.class) {
            HashMap<Integer, Tuple2<String, Integer>> newFileLineMap = new HashMap<Integer, Tuple2<String, Integer>>();
            try {
                PluginInterface.cleanStagingHandlers(this.waveSystem, this.ingestionApi, null, this.objectMapper);
                this.handlersComingFromFile.clear();
                try {
                    Files.walk(this.folder.toPath(), new FileVisitOption[0]).forEach(path -> {
                        if (path.getFileName().toString().endsWith(".groovy")) {
                            try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
                                allScripts.append("sandbox.startScript()\n");
                                allScripts.append(new BufferedReader(new InputStreamReader(fileInputStream)).lines().collect(Collectors.joining("\n")));
                                allScripts.append("\nsandbox.captureHadlers(\"");
                                allScripts.append(new String(Base64.getEncoder().encode(path.toFile().getAbsolutePath().toString().getBytes())));
                                allScripts.append("\")\n");
                                long lineCount = this.countLines(allScripts);
                                int line = 0;
                                while ((long)newFileLineMap.size() < lineCount) {
                                    newFileLineMap.put(newFileLineMap.size(), Tuple.of((Object)path.getFileName().toString(), (Object)(line++ - shift)));
                                }
                            }
                            catch (IOException e) {
                                logger.error("Exception when parsing script [{}]", path, (Object)e);
                                throw new IllegalStateException(e);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.groovyShell = new GroovyShell();
                this.groovyShell.setVariable("sandbox", (Object)this);
                System.out.println(allScripts.toString());
                this.groovyShell.evaluate(allScripts.toString());
                PluginInterface.getStagingComputingGraph().setClassLoader((ClassLoader)this.groovyShell.getClassLoader());
                this.wrapHandlersWithException(newFileLineMap);
                PluginInterface.switchToStagingHandlers(this.waveSystem, this.ingestionApi, null, null);
                HashSet classes = new HashSet();
                logger.info("scripts updated");
                this.fileLineMap = newFileLineMap;
            }
            catch (Throwable e) {
                logger.info("Exception when evaluating scripts: ", this.replaceStackTrace(e, newFileLineMap));
            }
            return;
        }
    }

    private void wrapHandlersWithException(Map<Integer, Tuple2<String, Integer>> fileLineMap) {
        for (Handler handler : PluginInterface.getStagingComputingGraph().getHandlers()) {
            handler.setWrapper(oldFn -> {
                try {
                    return ((CompletableFuture)((CompletableFuture)oldFn.get()).handle((unused, throwable) -> throwable)).thenApply(throwable -> {
                        if (throwable != null) {
                            this.replaceStackTrace((Throwable)throwable, fileLineMap);
                            throw new IllegalStateException((Throwable)throwable);
                        }
                        return null;
                    });
                }
                catch (Throwable throwable2) {
                    this.replaceStackTrace(throwable2, fileLineMap);
                    throw new IllegalStateException(throwable2);
                }
            });
        }
    }

    private int countLines(StringBuilder allScripts) {
        return (int)allScripts.toString().chars().filter(x -> x == 10).count();
    }

    private Throwable replaceStackTrace(Throwable e, Map<Integer, Tuple2<String, Integer>> fileLineMap) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            Tuple2<String, Integer> replacement;
            StackTraceElement stackTraceElement = e.getStackTrace()[i];
            if (stackTraceElement != null && stackTraceElement.getFileName() != null && stackTraceElement.getFileName().endsWith("Script1.groovy") && (replacement = fileLineMap.get(stackTraceElement.getLineNumber())) != null) {
                stackTrace[i] = new StackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), (String)replacement._1, (Integer)replacement._2);
            }
            e.setStackTrace(stackTrace);
        }
        if (e.getCause() != null && e.getCause() != e) {
            this.replaceStackTrace(e.getCause(), fileLineMap);
        }
        return e;
    }

    private String getFolderLock(String folderAbsolutePath) {
        return this.folderLocks.computeIfAbsent(folderAbsolutePath, k -> k);
    }

    private Set<File> getDirectoryByType(String aClass) {
        return this.directoriesByMappedTypes.computeIfAbsent(aClass, unused -> new HashSet());
    }

    public void startScript() {
        PluginInterface.getStagingComputingGraph().clearRegisteredHandlers();
    }

    public void captureHadlers(String base64Path) {
        this.handlersComingFromFile.put(new String(Base64.getDecoder().decode(base64Path)), new HashSet<String>(PluginInterface.getStagingComputingGraph().getRegisteredHandlers()));
    }

    private void updateFolders(Set<File> foldersToUpdate) {
        if (PluginInterface.getCurrentComputingGraph() == null) {
            return;
        }
        for (File folder : foldersToUpdate) {
            this.processFolder(folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFolder(File folder) {
        try {
            String string = this.getFolderLock(folder.getAbsolutePath());
            synchronized (string) {
                logger.info("processing folder: [{}]", (Object)folder);
                try {
                    Persistency persistency = new Persistency(new File(folder.getAbsolutePath() + "/-out"), false);
                    ObjectWrapper[] objectWrappers = (ObjectWrapper[])Arrays.stream(folder.listFiles()).filter(file -> !file.isDirectory() && file.getName().endsWith(".json")).map(fileToProcess -> {
                        try {
                            return ((SerializedObjectWrapper)this.objectMapper.readValue(fileToProcess, SerializedObjectWrapper.class)).convert(this.objectMapper, PluginInterface.getCurrentComputingGraph().getAllRegisteredClasses(), persistency, fileToProcess.toPath().getFileName().toString().replaceAll("\\.json$", "")).setDepthLimit(-1);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }).toArray(ObjectWrapper[]::new);
                    WaveRun run = new WaveRun(PluginInterface.getCurrentComputingGraph());
                    PluginInterface.getCurrentComputingGraph().compute((ObjectWrapper[])Stream.of(objectWrappers).map(o -> o.setRun(run)).toArray(ObjectWrapper[]::new)).get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        catch (Exception e) {
            logger.error("", this.replaceStackTrace(e, this.fileLineMap));
        }
        logger.info("done processing folder: [{}]", (Object)folder);
    }

    private Set<String> getTypesForFolder(File folder) {
        return this.typesByFolder.computeIfAbsent(folder, unused -> new HashSet());
    }

    private Class<?> getClass(String className) {
        if (className.equals("Probe")) {
            return Probe.class;
        }
        if (className.equals("Launch")) {
            return Launch.class;
        }
        return (Class)this.groovyShell.evaluate(className);
    }

    public static String getClassName(String fileName) {
        String s = fileName.replaceAll("[.-].*$", "");
        return s;
    }

    public GroovyShell getGroovyShell() {
        return this.groovyShell;
    }

    public Sandbox setGroovyShell(GroovyShell groovyShell) {
        this.groovyShell = groovyShell;
        return this;
    }
}

