/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.xebialabs.impact.wave.scripting.engine.ComputingGraphBase;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.ObjectWrapper;
import com.xebialabs.impact.wave.scripting.engine.ReducerState;
import com.xebialabs.impact.wave.scripting.engine.ReducingHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Run<C extends ContextBase<C>> {
    private static final Logger logger = LoggerFactory.getLogger(Run.class);
    private Map<ReducingHandler<?, C>, ReducerState> states = new ConcurrentHashMap();
    private final ComputingGraphBase computingGraph;
    private final Set<String> sourceClassesUsed = new HashSet<String>();

    public Run(ComputingGraphBase computingGraph) {
        this.computingGraph = computingGraph;
    }

    public ReducerState<C> getReducerState(ReducingHandler<?, C> handler) {
        return this.states.computeIfAbsent(handler, unused -> new ReducerState(this.computingGraph, handler, this));
    }

    public <D> ObjectWrapper<D, C> wrapObject(D object, ObjectWrapper<?, C> parent, String ... name) {
        return this.computingGraph.wrapObject(object, parent, name).setRun(this);
    }

    public void rememberProcessedClass(String simpleName) {
        this.sourceClassesUsed.add(simpleName);
    }

    public Set<String> getSourceClassesUsed() {
        return this.sourceClassesUsed;
    }

    public String toString() {
        return super.toString().replaceAll("^.*\\@", "");
    }
}

