import com.xebialabs.impact.api.CrawlerCredentialsDTO
import com.xebialabs.impact.caagile.DateHelper
import com.xebialabs.impact.wave.scripting.PluginInterface
import com.xebialabs.impact.wave.scripting.um.Other
import com.xebialabs.impact.wave.scripting.um.UmModel

class TicketUmModel extends UmModel {
    String id
    int version
    long startMs
    String title
    String ticketType
    String status
    String assignee
    String priority
    List<String> labels
    List<String> affectsVersions
    List<String> components
    double storyPoints
    Map<String, Object> additionalFields = new HashMap<>()
    Map<String, Object> customFields = new HashMap<>()

}

class TicketUmModels {
    String workspaceId
    String artefactVersion
    String id
    List<TicketUmModel> revisions = new ArrayList<>()
}


PluginInterface
        .map(CrawledEntityRevision)
        .into(TicketUmModel)
        .via({ revision, ctx ->
    TicketUmModel model = new TicketUmModel()
    model.version = revision.entity.version.toInteger()
    model.id = revision.entity.workspace + "/" + revision.entity.id.toString()
    model.title = revision.entity.fieldValues.getOrDefault("title", "")
    model.status = revision.entity.fieldValues.get("state")
    model.additionalFields.putAll(revision.entity.fieldValues)
    model.additionalFields.remove("state")
    model.additionalFields.remove("title")
    model.additionalFields.put("FormattedID", revision.entity.formattedId)
    model.ticketType = revision.entity.objectType
    model.priority = revision.entity.priority
    model.startMs = DateHelper.parseDate(revision.entity.creationDate)
    model.setOther(new Other())
    model.urlParts = new HashMap<>()
    model.urlParts.put("projectId", revision.entity.projectId)
    String projectSuffix = "ud"
    if (ctx.crawlerMessageWithCredentials.credentials.filters != null) {
        if (ctx.crawlerMessageWithCredentials.credentials.filters.get("PROJECT_URL_SUFFIX") != null) {
            if (!ctx.crawlerMessageWithCredentials.credentials.filters.get("PROJECT_URL_SUFFIX").filter.isEmpty()) {
                projectSuffix = ctx.crawlerMessageWithCredentials.credentials.filters.get("PROJECT_URL_SUFFIX").filter.get(0);
            }
        }
    }
    String objectTypeForUrl = revision.entity.objectType.toLowerCase()
    if (objectTypeForUrl.equals("hierarchicalrequirement")) {
        objectTypeForUrl = "userstory"
    }
    model.urlParts.put("objectType", objectTypeForUrl)
    model.urlParts.put("projectSuffix", projectSuffix)
    model.urlParts.put("objectId", revision.entity.id.toString())
    if (revision.isCurrentRevision) {
        model.getOther().getRelations().put("title", model.title)
        model.getOther().getRelations().put("formattedId", revision.entity.formattedId)
        model.getOther().getRelations().put("shortId", revision.entity.id.toString())
        revision.relations.forEach({ k, v ->
            model.getOther().getRelations().put("rel-" + k, v)
        })
    }
    revision.entity.customFields.forEach({ k, v ->
        model.customFields.put(revision.entity.workspace + '/' + revision.entity.objectType + '/' + k, v)
    })
    ctx.emit(model)

})

PluginInterface.reduce(TicketUmModel).into(PushDataPackage).via({ stream ->
    PushDataPackage pushDataPackage = new PushDataPackage()
    pushDataPackage.ticketUmModels = new TicketUmModels()
    stream.get({ model ->
        pushDataPackage.ticketUmModels.revisions.add(model)
        pushDataPackage.ticketUmModels.id = model.id
        if (pushDataPackage.ticketUmModels.artefactVersion == null ||
                Long.parseLong(pushDataPackage.ticketUmModels.artefactVersion) < model.startMs) {
            pushDataPackage.ticketUmModels.artefactVersion = String.valueOf(model.startMs)
        }
    })
    stream.onFinish({
        if (!pushDataPackage.ticketUmModels.revisions.isEmpty()) {
            stream.emit(pushDataPackage)
        }
    })

})
