/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.example;

import akka.actor.ActorSystem;
import akka.http.javadsl.Http;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.headers.BasicHttpCredentials;
import akka.http.javadsl.model.headers.HttpCredentials;
import akka.util.ByteString;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.api.PullMessagesWithStreamingRequestVM;
import com.xebialabs.impact.api.PullMessagesWithStreamingResponseVM;
import com.xebialabs.impact.wave.AsyncAction;
import com.xebialabs.impact.wave.EmptyAction;
import com.xebialabs.impact.wave.ExceptionHandler;
import com.xebialabs.impact.wave.WaveAction;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.scripting.PluginInterface;
import com.xebialabs.impact.wave.ssl.HttpsConnectionContextProvider;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestionServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(IngestionServiceHelper.class);

    public static AsyncAction getPoller(WaveSystem waveSystem, ObjectMapper objectMapper, ExceptionHandler exceptionHandler, Class<? extends WaveAction> probeAction, Class<? extends WaveAction> launchAction, String pluginId) {
        String url = "https://" + AgathaConfiguration.getIngestionRestHost() + ":" + AgathaConfiguration.getIngestionRestPort() + "/api/crawler/pull-um-messages";
        BasicHttpCredentials httpCredentials = HttpCredentials.createBasicHttpCredentials((String)AgathaConfiguration.getDefaultApiUsername(), (String)AgathaConfiguration.getDefaultApiPassword());
        return asyncCb -> {
            HttpRequest request = (HttpRequest)((HttpRequest)HttpRequest.POST((String)url).addCredentials((HttpCredentials)httpCredentials)).withEntity((ContentType)ContentTypes.APPLICATION_JSON, IngestionServiceHelper.buildPullRequest(objectMapper, exceptionHandler, waveSystem, PluginInterface.getCurrentComputingGraph().getPluginId()));
            Http.get((ActorSystem)waveSystem.getSystem()).singleRequest(request, HttpsConnectionContextProvider.httpsConnectionContext(waveSystem.getSystem())).thenComposeAsync(r -> r.entity().getDataBytes().runFold((Object)ByteString.empty(), ByteString::concat, waveSystem.getMaterializer())).thenAccept(b -> {
                Try<PullMessagesWithStreamingResponseVM> maybeResponse = IngestionServiceHelper.parseResponse(b, objectMapper);
                maybeResponse.onFailure(e -> {
                    throw new IllegalStateException((Throwable)e);
                }).onSuccess(responseVM -> asyncCb.invoke((Object)(responseVM.getMessages().isEmpty() ? new EmptyAction() : (CrawlerMessageWithCredentials)responseVM.getMessages().get(0))));
            }).handle((v, e) -> e).thenComposeAsync(e -> {
                if (e != null) {
                    return ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(v -> (CompletionStage)exceptionHandler.apply(waveSystem.getSystem(), waveSystem.getMaterializer(), null, e))).handle((v, e1) -> {
                        if (e1 != null) {
                            logger.error("Unhandled exception when handling exception :)", e1, e);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e2) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        return null;
                    })).thenRun(() -> asyncCb.invoke((Object)new EmptyAction()));
                }
                return CompletableFuture.completedFuture(null);
            });
        };
    }

    private static byte[] buildPullRequest(ObjectMapper objectMapper, ExceptionHandler exceptionHandler, WaveSystem system, String pluginId) {
        try {
            return objectMapper.writeValueAsBytes((Object)new PullMessagesWithStreamingRequestVM().setN(1).setTenantId(AgathaConfiguration.getTenantId()).setPluginId(pluginId));
        }
        catch (JsonProcessingException e) {
            exceptionHandler.apply(system.getSystem(), system.getMaterializer(), null, (Object)e);
            return new byte[0];
        }
    }

    private static Try<PullMessagesWithStreamingResponseVM> parseResponse(ByteString b, ObjectMapper objectMapper) {
        return Try.of((CheckedFunction0 & Serializable)() -> (PullMessagesWithStreamingResponseVM)objectMapper.readValue(b.toArray(), PullMessagesWithStreamingResponseVM.class));
    }
}

