/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.jsonstreaming;

import com.xebialabs.agatha.jsonstreaming.DataConsumer;
import com.xebialabs.agatha.jsonstreaming.DataWindowConsumer;
import com.xebialabs.agatha.jsonstreaming.IncompleteSourceStreamException;
import com.xebialabs.agatha.jsonstreaming.Parsed;
import com.xebialabs.agatha.jsonstreaming.ParserCore;
import com.xebialabs.agatha.jsonstreaming.RegexpConsumer;
import com.xebialabs.agatha.jsonstreaming.RegexpHandler;
import com.xebialabs.agatha.jsonstreaming.WindowBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;

public class ParserWithSugar<T extends ParserWithSugar>
extends ParserCore<T> {
    private List<Integer> callCounters;

    public T onDeepDataWindow(int minWindowSize, DataWindowConsumer fn) {
        WindowBuffer wb = new WindowBuffer(minWindowSize, fn);
        this.onDeepData((buffer, offset, length, isFirst, isFinish) -> {
            if (isFirst) {
                wb.reset();
            }
            wb.write(buffer, offset, length);
            if (isFinish) {
                wb.close();
            }
        });
        return (T)this;
    }

    public T onDeepRegexp(Matcher matcher, int groupToTrack, int minWindowSize, RegexpConsumer fn) {
        RegexpHandler rh = new RegexpHandler(matcher, groupToTrack, fn);
        this.onDeepDataWindow(minWindowSize, rh::onDataWindow);
        return (T)this;
    }

    public T onArray(Consumer<CharSequence> fn) {
        int level = this.getCurrentLevel() + 1;
        this.onDeepArray(path -> {
            if (this.getCurrentLevel() == level) {
                fn.accept(this.getRelativePath(level - 1));
            }
        });
        return (T)this;
    }

    public T onValue(BiConsumer<CharSequence, ParserCore.Type> fn) {
        int level = this.getCurrentLevel() + 1;
        this.onDeepValue((path, type) -> {
            if (this.getCurrentLevel() == level) {
                fn.accept(this.getRelativePath(level - 1), (ParserCore.Type)((Object)type));
            }
        });
        return (T)this;
    }

    public T onObject(Consumer<CharSequence> fn) {
        int level = this.getCurrentLevel() + 1;
        this.onDeepObject(path -> {
            if (this.getCurrentLevel() == level) {
                fn.accept(this.getRelativePath(level - 1));
            }
        });
        return (T)this;
    }

    public T onData(DataConsumer fn) {
        int level = this.getCurrentLevel();
        this.onDeepData((buffer, offset, length, isFirst, isFinish) -> {
            if (this.getCurrentLevel() == level) {
                fn.accept(buffer, offset, length, isFirst, isFinish);
            }
        });
        return (T)this;
    }

    public T readDataTillEofAndThen(Consumer<String> fn) {
        StringBuffer sb = new StringBuffer();
        this.onData((buf, off, len, isFirst, isFinal) -> {
            sb.append(buf, off, len);
            if (isFinal) {
                fn.accept(new String(sb));
            }
        });
        return (T)this;
    }

    public T fillMap(Map<String, Object> map) {
        this.onObject(p -> {
            HashMap<String, Object> inner = new HashMap<String, Object>();
            map.put(p.subSequence(1, p.length()).toString(), inner);
            this.fillMap(inner);
        });
        this.onArray(p -> {
            ArrayList<Object> inner = new ArrayList<Object>();
            map.put(p.subSequence(1, p.length()).toString(), inner);
            this.fillList(inner);
        });
        this.onValue((p, t) -> this.readDataTillEofAndThen(s -> {
            String key = p.subSequence(1, p.length()).toString();
            map.put(key, this.makeValue((ParserCore.Type)((Object)t), (String)s));
        }));
        return (T)this;
    }

    private Object makeValue(ParserCore.Type t, String s) {
        switch (t) {
            case STRING: {
                return s;
            }
            case NON_STRING: {
                switch (s) {
                    case "false": 
                    case "true": {
                        return Boolean.parseBoolean(s);
                    }
                    case "null": {
                        return null;
                    }
                }
                if (-1 != s.indexOf(".")) {
                    return Double.parseDouble(s);
                }
                return Long.parseLong(s);
            }
        }
        throw new IllegalStateException("unexpected value type: [" + (Object)((Object)t) + "], only STRING or NON_STRING are allowed here");
    }

    public T fillList(List<Object> list) {
        this.onObject(p -> {
            HashMap<String, Object> inner = new HashMap<String, Object>();
            list.add(inner);
            this.fillMap(inner);
        });
        this.onArray(p -> {
            ArrayList<Object> inner = new ArrayList<Object>();
            list.add(inner);
            this.fillList(inner);
        });
        this.onValue((p, t) -> this.readDataTillEofAndThen(value -> list.add(this.makeValue((ParserCore.Type)((Object)t), (String)value))));
        return (T)this;
    }

    public T onValue(String valuePath, Consumer<ParserCore.Type> fn) {
        int level = this.getCurrentLevel();
        this.onDeepValue((path, type) -> {
            if (valuePath.contentEquals(this.getRelativePath(level))) {
                fn.accept((ParserCore.Type)((Object)type));
            }
        });
        return (T)this;
    }

    public T onObject(String objectPath, Runnable fn) {
        int level = this.getCurrentLevel();
        this.onDeepObject(path -> {
            if (objectPath.contentEquals(this.getRelativePath(level))) {
                fn.run();
            }
        });
        return (T)this;
    }

    public T onArray(String arrayPath, Runnable fn) {
        int level = this.getCurrentLevel();
        this.onDeepArray(path -> {
            if (arrayPath.contentEquals(this.getRelativePath(level))) {
                fn.run();
            }
        });
        return (T)this;
    }

    public T readStringValueAndThen(String valuePath, Consumer<String> fn) {
        this.onValue(valuePath, type -> this.readDataTillEofAndThen(fn::accept));
        return (T)this;
    }

    public T readLongValueAndThen(String valuePath, Consumer<Long> fn) {
        this.onValue(valuePath, type -> this.readDataTillEofAndThen(value -> {
            if ("null".equals(value)) {
                fn.accept(null);
            } else {
                fn.accept(Long.parseLong(value));
            }
        }));
        return (T)this;
    }

    public T readIntValueAndThen(String valuePath, Consumer<Integer> fn) {
        this.onValue(valuePath, type -> this.readDataTillEofAndThen(value -> {
            if ("null".equals(value)) {
                fn.accept(null);
            } else {
                fn.accept(Integer.parseInt(value));
            }
        }));
        return (T)this;
    }

    public T readDoubleValueAndThen(String valuePath, Consumer<Double> fn) {
        this.onValue(valuePath, type -> this.readDataTillEofAndThen(value -> {
            if ("null".equals(value)) {
                fn.accept(null);
            } else {
                fn.accept(Double.parseDouble(value));
            }
        }));
        return (T)this;
    }

    public T readFloatValueAndThen(String valuePath, Consumer<Float> fn) {
        this.onValue(valuePath, type -> this.readDataTillEofAndThen(value -> {
            if ("null".equals(value)) {
                fn.accept(null);
            } else {
                fn.accept(Float.valueOf(Float.parseFloat(value)));
            }
        }));
        return (T)this;
    }

    public T readBoolValueAndThen(String valuePath, Consumer<Boolean> fn) {
        this.onValue(valuePath, type -> this.readDataTillEofAndThen(value -> {
            if ("null".equals(value)) {
                fn.accept(null);
            } else {
                fn.accept(Boolean.parseBoolean(value));
            }
        }));
        return (T)this;
    }

    public StringBuilder readValueInto(String valuePath) {
        StringBuilder sb = new StringBuilder();
        this.onValue(valuePath, type -> this.onData((buffer, offset, length, isFirst, isFinish) -> {
            if (isFirst) {
                sb.setLength(0);
            }
            sb.append(buffer, offset, length);
        }));
        return sb;
    }

    public StringBuilder readRawInto(String valuePath) {
        StringBuilder sb = new StringBuilder();
        this.onArray(valuePath, () -> {
            ParserWithSugar cfr_ignored_0 = (ParserWithSugar)this.onRaw(sb::append);
        });
        this.onObject(valuePath, () -> {
            ParserWithSugar cfr_ignored_0 = (ParserWithSugar)this.onRaw(sb::append);
        });
        this.onValue(valuePath, type -> {
            ParserWithSugar cfr_ignored_0 = (ParserWithSugar)this.onRaw(sb::append);
        });
        return sb;
    }

    public void readFromChannel(ReadableByteChannel channel, int bufferSize) throws IOException {
        int read;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        boolean empty = true;
        while (-1 != (read = channel.read(buffer))) {
            if (read > 0) {
                empty = false;
            }
            this.write(buffer.array(), 0, read);
            buffer.rewind();
        }
        if (empty) {
            throw new IncompleteSourceStreamException("empty document");
        }
        try {
            this.finish();
        }
        catch (IOException e) {
            throw new IncompleteSourceStreamException(e);
        }
    }

    public T readRawAndThen(Consumer<CharSequence> fn) {
        StringBuilder sb = new StringBuilder();
        this.onFinish(() -> fn.accept(sb));
        this.onRaw(sb::append);
        return (T)this;
    }

    public T writeAndClose(byte[] bytes) throws IOException {
        this.write(bytes);
        this.close();
        return (T)this;
    }

    public T writeAndClose(String json) throws IOException {
        this.write(json.getBytes());
        this.close();
        return (T)this;
    }

    public <U> Parsed<U> convertInto(String path, Convertor<U> fn) {
        StringBuilder sb = this.readRawInto(path);
        return () -> {
            try {
                return fn.convert(sb.toString());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        };
    }

    public Runnable once(Runnable fn) {
        return this.exactlyTimes(fn, 1);
    }

    public Runnable exactlyTimes(Runnable fn, int n) {
        int counterIndex = this.registerCounter(n);
        return () -> {
            this.checkCounter(counterIndex);
            fn.run();
        };
    }

    public <R> Consumer<R> once(Consumer<R> fn) {
        return this.exactlyTimes(fn, 1);
    }

    public <R> Consumer<R> exactlyTimes(Consumer<R> fn, int n) {
        int counterIndex = this.registerCounter(n);
        return v -> {
            this.checkCounter(counterIndex);
            fn.accept(v);
        };
    }

    public <R, S> BiConsumer<R, S> once(BiConsumer<R, S> fn) {
        return this.exactlyTimes(fn, 1);
    }

    public <R, S> BiConsumer<R, S> exactlyTimes(BiConsumer<R, S> fn, int n) {
        int counterIndex = this.registerCounter(n);
        return (v, u) -> {
            this.checkCounter(counterIndex);
            fn.accept(v, u);
        };
    }

    private int registerCounter(int times) {
        if (this.callCounters == null) {
            this.callCounters = new ArrayList<Integer>();
        }
        int counterIndex = this.callCounters.size();
        this.callCounters.add(times);
        return counterIndex;
    }

    private void checkCounter(int counterIndex) {
        int called = this.callCounters.get(counterIndex);
        if (called == 0) {
            throw new IllegalStateException(String.format("Method called more then defined number of, counterIndex = [%s]", counterIndex));
        }
        this.callCounters.set(counterIndex, called - 1);
    }

    private void finalizeCounters() {
        if (this.callCounters != null) {
            for (int i = 0; i < this.callCounters.size(); ++i) {
                if (this.callCounters.get(i) == 0) continue;
                throw new IllegalStateException(String.format("Method was not called, counterIndex = [%s]", i));
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.finalizeCounters();
    }

    @FunctionalInterface
    public static interface Convertor<U> {
        public U convert(String var1) throws Exception;
    }
}

