/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.transform;

import com.xebialabs.agatha.crawlers.shared.transform.WrappedUM;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UMWrappedEntity<T> {
    private final String pluginId;
    private final String pluginVersion;
    private final String type;
    private final String typeVersion;
    private String id;
    private String version;
    private final T data;
    private final DataSourceTypeEnum dataSourceType;
    private WrappedUM wrappedData;

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeVersion() {
        return this.typeVersion;
    }

    public T getData() {
        return this.data;
    }

    public UMWrappedEntity(String pluginId, String pluginVersion, String type, String typeVersion, T data, DataSourceTypeEnum dataSourceType) {
        this.pluginId = pluginId;
        this.pluginVersion = pluginVersion;
        this.type = type;
        this.typeVersion = typeVersion;
        this.data = data;
        this.dataSourceType = dataSourceType;
    }

    public UMWrappedEntity<T> wrap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        if (this.data instanceof List) {
            entityMap.put(String.format("%s.%s", this.type, this.typeVersion), this.data);
        } else {
            entityMap.put(String.format("%s.%s", this.type, this.typeVersion), Stream.of(this.data).collect(Collectors.toList()));
        }
        dataMap.put(String.format("%s.%s", this.pluginId, this.pluginVersion), entityMap);
        this.wrappedData = new WrappedUM(dataMap);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public UMWrappedEntity<T> setId(String id) {
        this.id = id;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public UMWrappedEntity<T> setVersion(String version) {
        this.version = version;
        return this;
    }

    public WrappedUM getWrappedData() {
        return this.wrappedData;
    }

    public DataSourceTypeEnum getDataSourceType() {
        return this.dataSourceType;
    }
}

