/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.ingestion_api;

import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.impact.api.SetContextKeyRequest;
import com.xebialabs.impact.wave.AsyncContextKeysConsumer;
import com.xebialabs.impact.wave.ContextKeyValue;
import com.xebialabs.impact.wave.WaveAction;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.ingestion_api.BaseDataIngestionConsumer;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class DataIngestionAsyncContextKeysConsumer
extends BaseDataIngestionConsumer
implements AsyncContextKeysConsumer {
    public DataIngestionAsyncContextKeysConsumer(IngestionApiAsync ingestionApiAsync, String pluginId) {
        super(ingestionApiAsync, pluginId);
    }

    public CompletionStage<Void> apply(WaveAction thisAction, Collection<ContextKeyValue> contextKeyValues, WaveSystem waveSystem) {
        return WaveAction.allOf(contextKeyValues.stream().map(contextKeyValue -> this.ingestionApiAsync.sendContextKeyValues(new SetContextKeyRequest().setDataSourceId(thisAction.getDataSourceDetails().getDataSourceId()).setKey(contextKeyValue.getKey()).setPluginId(this.pluginId).setTenantId(AgathaConfiguration.getTenantId()).setValue(contextKeyValue.getValue()))).collect(Collectors.toList()));
    }
}

