/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.engine;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;

public class Path {
    private final Path parent;
    private final String name;

    public Path(Path parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @JsonIgnore
    public String getPathAsString() {
        return (this.parent != null ? this.parent.getPathAsString() + "--" : "") + this.name;
    }

    @JsonIgnore
    public String getFullPath() {
        return this.name + (this.parent == null ? "" : "---" + this.parent.getFullPath());
    }

    public Path getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return Objects.equals(this.parent, path.parent) && Objects.equals(this.name, path.name);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name);
    }
}

