/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.Done;
import akka.Done$;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.CoordinatedShutdown;
import akka.actor.CoordinatedShutdown$ClusterDowningReason$;
import akka.actor.CoordinatedShutdown$ClusterLeavingReason$;
import akka.actor.CoordinatedShutdown$JvmExitReason$;
import akka.actor.CoordinatedShutdown$UnknownReason$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import akka.dispatch.ExecutionContexts$sameThreadExecutionContext$;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class CoordinatedShutdown$
implements ExtensionId<CoordinatedShutdown>,
ExtensionIdProvider {
    public static CoordinatedShutdown$ MODULE$;
    private final String PhaseBeforeServiceUnbind;
    private final String PhaseServiceUnbind;
    private final String PhaseServiceRequestsDone;
    private final String PhaseServiceStop;
    private final String PhaseBeforeClusterShutdown;
    private final String PhaseClusterShardingShutdownRegion;
    private final String PhaseClusterLeave;
    private final String PhaseClusterExiting;
    private final String PhaseClusterExitingDone;
    private final String PhaseClusterShutdown;
    private final String PhaseBeforeActorSystemTerminate;
    private final String PhaseActorSystemTerminate;
    private volatile boolean akka$actor$CoordinatedShutdown$$runningJvmHook;

    static {
        new CoordinatedShutdown$();
    }

    @Override
    public Extension apply(ActorSystem system) {
        return ExtensionId.apply$(this, system);
    }

    @Override
    public final int hashCode() {
        return ExtensionId.hashCode$(this);
    }

    @Override
    public final boolean equals(Object other) {
        return ExtensionId.equals$(this, other);
    }

    public String PhaseBeforeServiceUnbind() {
        return this.PhaseBeforeServiceUnbind;
    }

    public String PhaseServiceUnbind() {
        return this.PhaseServiceUnbind;
    }

    public String PhaseServiceRequestsDone() {
        return this.PhaseServiceRequestsDone;
    }

    public String PhaseServiceStop() {
        return this.PhaseServiceStop;
    }

    public String PhaseBeforeClusterShutdown() {
        return this.PhaseBeforeClusterShutdown;
    }

    public String PhaseClusterShardingShutdownRegion() {
        return this.PhaseClusterShardingShutdownRegion;
    }

    public String PhaseClusterLeave() {
        return this.PhaseClusterLeave;
    }

    public String PhaseClusterExiting() {
        return this.PhaseClusterExiting;
    }

    public String PhaseClusterExitingDone() {
        return this.PhaseClusterExitingDone;
    }

    public String PhaseClusterShutdown() {
        return this.PhaseClusterShutdown;
    }

    public String PhaseBeforeActorSystemTerminate() {
        return this.PhaseBeforeActorSystemTerminate;
    }

    public String PhaseActorSystemTerminate() {
        return this.PhaseActorSystemTerminate;
    }

    public CoordinatedShutdown.Reason unknownReason() {
        return CoordinatedShutdown$UnknownReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason jvmExitReason() {
        return CoordinatedShutdown$JvmExitReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterDowningReason() {
        return CoordinatedShutdown$ClusterDowningReason$.MODULE$;
    }

    public CoordinatedShutdown.Reason clusterLeavingReason() {
        return CoordinatedShutdown$ClusterLeavingReason$.MODULE$;
    }

    public boolean akka$actor$CoordinatedShutdown$$runningJvmHook() {
        return this.akka$actor$CoordinatedShutdown$$runningJvmHook;
    }

    private void akka$actor$CoordinatedShutdown$$runningJvmHook_$eq(boolean x$1) {
        this.akka$actor$CoordinatedShutdown$$runningJvmHook = x$1;
    }

    @Override
    public CoordinatedShutdown get(ActorSystem system) {
        return (CoordinatedShutdown)ExtensionId.get$(this, system);
    }

    public CoordinatedShutdown$ lookup() {
        return this;
    }

    @Override
    public CoordinatedShutdown createExtension(ExtendedActorSystem system) {
        Config conf = system.settings().config().getConfig("akka.coordinated-shutdown");
        scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases = this.phasesFromConfig(conf);
        CoordinatedShutdown coord = new CoordinatedShutdown(system, phases);
        this.initPhaseActorSystemTerminate(system, conf, coord);
        this.initJvmHook(system, conf, coord);
        system.registerOnTermination((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Cancellable cancellable = coord.akka$actor$CoordinatedShutdown$$actorSystemJvmHook();
            Cancellable cancellable2 = OptionVal$Some$.MODULE$.unapply(cancellable);
            if (!OptionVal$.MODULE$.isEmpty$extension(cancellable2)) {
                Cancellable cancellable3 = OptionVal$.MODULE$.get$extension(cancellable2);
                if (!MODULE$.akka$actor$CoordinatedShutdown$$runningJvmHook() && !cancellable3.isCancelled()) {
                    cancellable3.cancel();
                    OptionVal$.MODULE$.None();
                    coord.akka$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(null);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return coord;
    }

    private void initPhaseActorSystemTerminate(ActorSystem system, Config conf, CoordinatedShutdown coord) {
        block0: {
            boolean terminateActorSystem = conf.getBoolean("terminate-actor-system");
            boolean exitJvm = conf.getBoolean("exit-jvm");
            if (!terminateActorSystem && !exitJvm) break block0;
            coord.addTask(this.PhaseActorSystemTerminate(), "terminate-system", (Function0<Future<Done>>)(Function0 & Serializable & scala.Serializable)() -> {
                Future future;
                if (exitJvm && terminateActorSystem) {
                    FiniteDuration timeout = coord.timeout(MODULE$.PhaseActorSystemTerminate());
                    Thread t = new Thread(system, timeout){
                        private final ActorSystem system$1;
                        private final FiniteDuration timeout$1;

                        public void run() {
                            block0: {
                                if (!Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready($this.system$1.whenTerminated(), (Duration)$this.timeout$1)).isFailure() || CoordinatedShutdown$.MODULE$.akka$actor$CoordinatedShutdown$$runningJvmHook()) break block0;
                                System.exit(0);
                            }
                        }
                        {
                            this.system$1 = system$1;
                            this.timeout$1 = timeout$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(akka.actor.CoordinatedShutdown$$anon$1 )}, serializedLambda);
                        }
                    };
                    t.setName("CoordinatedShutdown-exit");
                    t.start();
                }
                if (terminateActorSystem) {
                    future = system.terminate().map((Function1 & Serializable & scala.Serializable)x$1 -> {
                        block0: {
                            if (!exitJvm || MODULE$.akka$actor$CoordinatedShutdown$$runningJvmHook()) break block0;
                            System.exit(0);
                        }
                        return Done$.MODULE$;
                    }, (ExecutionContext)ExecutionContexts$sameThreadExecutionContext$.MODULE$);
                } else if (exitJvm) {
                    System.exit(0);
                    future = Future$.MODULE$.successful((Object)Done$.MODULE$);
                } else {
                    future = Future$.MODULE$.successful((Object)Done$.MODULE$);
                }
                return future;
            });
        }
    }

    private void initJvmHook(ActorSystem system, Config conf, CoordinatedShutdown coord) {
        block0: {
            boolean runByJvmShutdownHook;
            boolean bl = runByJvmShutdownHook = system.settings().JvmShutdownHooks() && conf.getBoolean("run-by-jvm-shutdown-hook");
            if (!runByJvmShutdownHook) break block0;
            coord.akka$actor$CoordinatedShutdown$$actorSystemJvmHook_$eq(OptionVal$Some$.MODULE$.apply(coord.addCancellableJvmShutdownHook((Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                MODULE$.akka$actor$CoordinatedShutdown$$runningJvmHook_$eq(true);
                if (!system.whenTerminated().isCompleted()) {
                    coord.log().debug("Starting coordinated shutdown from JVM shutdown hook");
                    try {
                        FiniteDuration totalTimeout = coord.totalTimeout().max(new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds());
                        boxedUnit = Await$.MODULE$.ready(coord.run(CoordinatedShutdown$JvmExitReason$.MODULE$), (Duration)totalTimeout);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        coord.log().warning("CoordinatedShutdown from JVM shutdown failed: {}", e.getMessage());
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        boxedUnit = boxedUnit2;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            })));
        }
    }

    public scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phasesFromConfig(Config conf) {
        String defaultPhaseTimeout = conf.getString("default-phase-timeout");
        Config phasesConf = conf.getConfig("phases");
        Config defaultPhaseConfig = ConfigFactory.parseString((String)new StringBuilder(86).append("\n      timeout = ").append(defaultPhaseTimeout).append("\n      recover = true\n      enabled = true\n      depends-on = []\n    ").toString());
        return (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(phasesConf.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String k;
            block5: {
                Tuple2 tuple2;
                block4: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block4;
                    k = (String)tuple2._1();
                    if (tuple2._2() instanceof Map) break block5;
                }
                if (tuple2 != null) {
                    String k2 = (String)tuple2._1();
                    Object v = tuple2._2();
                    throw new IllegalArgumentException(new StringBuilder(36).append("Expected object value for [").append(k2).append("], got [").append(v).append("]").toString());
                }
                throw new MatchError((Object)tuple2);
            }
            Config c = phasesConf.getConfig(k).withFallback((ConfigMergeable)defaultPhaseConfig);
            Set dependsOn = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("depends-on")).asScala()).toSet();
            FiniteDuration timeout = new package.DurationLong(package$.MODULE$.DurationLong(c.getDuration("timeout", TimeUnit.MILLISECONDS))).millis();
            boolean recover = c.getBoolean("recover");
            boolean enabled = c.getBoolean("enabled");
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new CoordinatedShutdown.Phase((Set<String>)dependsOn, timeout, recover, enabled));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public List<String> topologicalSort(scala.collection.immutable.Map<String, CoordinatedShutdown.Phase> phases) {
        ObjectRef result = ObjectRef.create((Object)List$.MODULE$.empty());
        ObjectRef unmarked = ObjectRef.create((Object)((Set)phases.keySet().$plus$plus((GenTraversableOnce)phases.values().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dependsOn(), Iterable$.MODULE$.canBuildFrom()))));
        ObjectRef tempMark = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        while (((Set)unmarked.elem).nonEmpty()) {
            CoordinatedShutdown$.depthFirstSearch$1((String)((Set)unmarked.elem).head(), phases, result, unmarked, tempMark);
        }
        return ((List)result.elem).reverse();
    }

    private static final void depthFirstSearch$1(String u2, scala.collection.immutable.Map phases$1, ObjectRef result$1, ObjectRef unmarked$1, ObjectRef tempMark$1) {
        block5: {
            if (((Set)tempMark$1.elem).apply((Object)u2)) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Cycle detected in graph of phases. It must be a DAG. ").append(new StringBuilder(59).append("phase [").append(u2).append("] depends transitively on itself. All dependencies: ").append(phases$1).toString()).toString());
            }
            if (!((Set)unmarked$1.elem).apply((Object)u2)) break block5;
            tempMark$1.elem = (Set)((Set)tempMark$1.elem).$plus((Object)u2);
            Option option = phases$1.get((Object)u2);
            if (option instanceof Some) {
                Some some = (Some)option;
                CoordinatedShutdown.Phase p = (CoordinatedShutdown.Phase)some.value();
                p.dependsOn().foreach((Function1 & Serializable & scala.Serializable)u -> {
                    CoordinatedShutdown$.depthFirstSearch$1(u, phases$1, result$1, unmarked$1, tempMark$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            unmarked$1.elem = (Set)((Set)unmarked$1.elem).$minus((Object)u2);
            tempMark$1.elem = (Set)((Set)tempMark$1.elem).$minus((Object)u2);
            String string = u2;
            result$1.elem = ((List)result$1.elem).$colon$colon((Object)string);
        }
    }

    private CoordinatedShutdown$() {
        MODULE$ = this;
        ExtensionId.$init$(this);
        this.PhaseBeforeServiceUnbind = "before-service-unbind";
        this.PhaseServiceUnbind = "service-unbind";
        this.PhaseServiceRequestsDone = "service-requests-done";
        this.PhaseServiceStop = "service-stop";
        this.PhaseBeforeClusterShutdown = "before-cluster-shutdown";
        this.PhaseClusterShardingShutdownRegion = "cluster-sharding-shutdown-region";
        this.PhaseClusterLeave = "cluster-leave";
        this.PhaseClusterExiting = "cluster-exiting";
        this.PhaseClusterExitingDone = "cluster-exiting-done";
        this.PhaseClusterShutdown = "cluster-shutdown";
        this.PhaseBeforeActorSystemTerminate = "before-actor-system-terminate";
        this.PhaseActorSystemTerminate = "actor-system-terminate";
        this.akka$actor$CoordinatedShutdown$$runningJvmHook = false;
    }
}

