/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.agatha.crawlers.api.IngestionApiRestImpl;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.ingestion_api.DataIngestionActionsSourceProvider;
import com.xebialabs.impact.wave.ingestion_api.exceptions.DataIngestionLoggingExceptionHandler;
import com.xebialabs.impact.wave.scripting.Sandbox;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveCrawlerBase {
    private static final Logger logger = LoggerFactory.getLogger(WaveCrawlerBase.class);

    public static void main(String[] args, String defaultFolderNameForScripts, Class<?> aClass) throws InterruptedException {
        ObjectMapper objectMapper = new ObjectMapper();
        IngestionApiRestImpl ingestionApiAsync = new IngestionApiRestImpl(objectMapper);
        File scriptsFolder = WaveCrawlerBase.getScriptsFolder(defaultFolderNameForScripts, aClass);
        DataIngestionLoggingExceptionHandler exceptionHandler = new DataIngestionLoggingExceptionHandler(objectMapper, "", (IngestionApiAsync)ingestionApiAsync);
        WaveSystem system = new WaveSystem(null, null, null, null, exceptionHandler, null, scriptsFolder.getAbsolutePath());
        if (scriptsFolder == null) {
            throw new IllegalStateException("tbd");
        }
        Sandbox sandbox = new Sandbox(scriptsFolder, objectMapper, system, (IngestionApiAsync)ingestionApiAsync);
        sandbox.start();
        DataIngestionActionsSourceProvider dataIngestionActionsSourceProvider = new DataIngestionActionsSourceProvider();
        Source<CrawlerMessageWithCredentials, NotUsed> actionsSource = dataIngestionActionsSourceProvider.getActionSource(exceptionHandler, system, null, null, "");
        system.process(actionsSource);
        Thread.currentThread().join();
        System.exit(0);
        system.shutdown().whenComplete((v, ex) -> System.exit(0));
    }

    public static File getScriptsFolder(String defaultFolderNameForScripts, Class<?> aClass) {
        String pluginScriptsFolder = AgathaConfiguration.pluginScriptsFolder();
        if (!pluginScriptsFolder.isEmpty()) {
            return new File(pluginScriptsFolder);
        }
        File folder = new File(defaultFolderNameForScripts);
        folder.mkdirs();
        String resourceFolder = "/";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(resourceFolder);
        if (url == null) {
            String name = aClass.getName().replace('.', '/') + ".class";
            System.out.println(name);
            url = aClass.getClassLoader().getResource(name);
        }
        System.out.println(url);
        String path = url.getPath();
        File jarFileOrFolder = new File(path);
        if (jarFileOrFolder.isDirectory()) {
            try {
                Files.list(jarFileOrFolder.toPath()).forEach(file -> {
                    File targetFile;
                    if (!file.toFile().isDirectory() && !(targetFile = new File(folder.getAbsolutePath() + "/" + file.getFileName())).exists()) {
                        try {
                            Files.copy(file, targetFile.toPath(), new CopyOption[0]);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return jarFileOrFolder;
        }
        if (url.getProtocol().equals("jar")) {
            String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
            JarFile jar = null;
            try {
                jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            Enumeration<JarEntry> entries = jar.entries();
            Pattern p = Pattern.compile("^\\/?([^\\/]+\\.groovy)$");
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                Matcher matcher = p.matcher(name);
                if (!matcher.find()) continue;
                try {
                    InputStream inputStream = jar.getInputStream(jarEntry);
                    Throwable throwable = null;
                    try {
                        File file2 = new File(folder + "/" + matcher.group(1));
                        if (file2.exists()) {
                            logger.info("File [{}] already exists, not overwriting it", (Object)file2);
                            continue;
                        }
                        logger.info("File [{}] does not exist, copying from resources", (Object)file2);
                        Files.copy(inputStream, file2.toPath(), new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            return folder;
        }
        throw new IllegalStateException("Unable to figure out source for scripts");
    }
}

