/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.example;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.wave.AsyncAction;
import com.xebialabs.impact.wave.AsyncContextKeysConsumer;
import com.xebialabs.impact.wave.AsyncDataConsumer;
import com.xebialabs.impact.wave.EmptyAction;
import com.xebialabs.impact.wave.ExceptionHandler;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.example.JiraProbeAction;
import com.xebialabs.impact.wave.example.StartWaveAction;
import com.xebialabs.impact.wave.ingestion_api.DataIngestionActionsSourceProvider;
import com.xebialabs.impact.wave.test.TestAckConsumer;
import com.xebialabs.impact.wave.test.TestAsyncActionConsumer;
import com.xebialabs.impact.wave.test.TestAsyncProbeResultConsumer;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;

public class JiraApp {
    private static final String PLUGIN_ID = "JiraPlugin";

    public static void main(String[] args) throws InterruptedException {
        ConcurrentLinkedDeque<CrawlerMessageWithCredentials> deque = new ConcurrentLinkedDeque<CrawlerMessageWithCredentials>();
        TestAckConsumer ackConsumer = new TestAckConsumer();
        ExceptionHandler & Serializable exceptionHandler = (ExceptionHandler & Serializable)(actorSystem, materializer, action, throwable) -> {
            System.out.println("I caught an exception");
            throwable.printStackTrace();
            return CompletableFuture.completedFuture(null);
        };
        TestAsyncActionConsumer asyncActionConsumer = new TestAsyncActionConsumer(deque);
        AsyncDataConsumer & Serializable asyncDataConsumer = (AsyncDataConsumer & Serializable)(action, data, waveSystem) -> CompletableFuture.completedFuture(null);
        AsyncContextKeysConsumer & Serializable asyncContextKeysConsumer = (AsyncContextKeysConsumer & Serializable)(action, contextKeyValues, waveSystem) -> CompletableFuture.completedFuture(null);
        TestAsyncProbeResultConsumer asyncProbeResultConsumer = new TestAsyncProbeResultConsumer();
        WaveSystem system = new WaveSystem(asyncActionConsumer, asyncDataConsumer, asyncContextKeysConsumer, ackConsumer, exceptionHandler, asyncProbeResultConsumer, AgathaConfiguration.pluginScriptsFolder());
        AsyncAction dequePoller = asyncCbk -> {
            if (!deque.isEmpty()) {
                asyncCbk.invoke(deque.poll());
            } else {
                asyncCbk.invoke((Object)new EmptyAction());
            }
        };
        DataIngestionActionsSourceProvider sourceProvider = new DataIngestionActionsSourceProvider();
        Source<CrawlerMessageWithCredentials, NotUsed> actionsSource = sourceProvider.getActionSource(exceptionHandler, system, JiraProbeAction.class, StartWaveAction.class, PLUGIN_ID);
        system.process(actionsSource);
        Thread.currentThread().join();
        System.exit(0);
        system.shutdown().whenComplete((v, ex) -> System.exit(0));
    }
}

