/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watcher {
    private static final Logger logger = LoggerFactory.getLogger(Watcher.class);

    public static <T> void watch(File folder, final UpdateCallback onUpdate) {
        FileAlterationObserver observer = new FileAlterationObserver(folder.getAbsolutePath(), (FileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".json"), FileFilterUtils.suffixFileFilter((String)".groovy")})}), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"-"))})}));
        FileAlterationMonitor monitor = new FileAlterationMonitor(100L);
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){
            private List<File> files = new CopyOnWriteArrayList<File>();

            public void onStart(FileAlterationObserver observer) {
                this.files.clear();
                super.onStart(observer);
            }

            public void onFileCreate(File file) {
                this.files.add(file);
            }

            public void onFileDelete(File file) {
                this.files.add(file);
            }

            public void onFileChange(File file) {
                this.files.add(file);
            }

            public void onStop(FileAlterationObserver observer) {
                if (!this.files.isEmpty()) {
                    try {
                        onUpdate.update(this.files);
                    }
                    catch (Exception e) {
                        logger.error("Exception when handing change: ", (Throwable)e);
                    }
                }
                super.onStop(observer);
            }
        };
        observer.addListener((FileAlterationListener)listener);
        monitor.addObserver(observer);
        try {
            monitor.start();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void watch1(File folder, Runnable onUpdate) {
        Callable<Object> objectCallable = () -> {
            try (WatchService watcher = folder.getAbsoluteFile().toPath().getFileSystem().newWatchService();){
                WatchKey register = folder.toPath().register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
                while (true) {
                    try {
                        WatchKey take = watcher.take();
                        if (take == null) {
                            logger.error("watcher.take returned null for [{}]", (Object)folder);
                            break;
                        }
                        register.reset();
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error("Exception when watching: ", (Throwable)e);
                    }
                    try {
                        onUpdate.run();
                    }
                    catch (Exception e) {
                        logger.error("Exception when refreshing scripts: ", (Throwable)e);
                    }
                }
            }
            return null;
        };
        Executors.newFixedThreadPool(1).submit(objectCallable);
    }

    @FunctionalInterface
    public static interface UpdateCallback {
        public void update(List<File> var1) throws Exception;
    }
}

