/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.services;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import com.xebialabs.agatha.crawlers.shared.models.PaginatedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCrawlService<C extends AbstractHttpCrawler, T extends BaseCrawlerMessage, R>
implements CrawlService {
    private static final Logger logger = LoggerFactory.getLogger(BaseCrawlService.class);
    protected final ResponseFetcher<C> responseFetcher;
    protected final C crawler;
    protected final T message;
    protected final BaseCrawlerMessage dataMessage;
    protected final Date validDate;

    public BaseCrawlService(C crawler, T message, BaseCrawlerMessage dataMessage) {
        this.crawler = crawler;
        this.message = message;
        this.dataMessage = dataMessage;
        this.validDate = crawler.getOldestValidDate();
        this.responseFetcher = new ResponseFetcher<C>(crawler);
    }

    public BaseCrawlService(C crawler, T message, BaseCrawlerMessage dataMessage, ResponseFetcher<C> responseFetcher) {
        this.crawler = crawler;
        this.message = message;
        this.dataMessage = dataMessage;
        this.validDate = crawler.getOldestValidDate();
        this.responseFetcher = responseFetcher;
    }

    protected BaseCrawlerMessage createDataMessage(T message, String dataKey, BaseCrawlerMessage baseCrawlerMessage) {
        baseCrawlerMessage.setTenantId(message.getTenantId());
        baseCrawlerMessage.setPluginId(message.getPluginId());
        baseCrawlerMessage.setMetadata(message.getMetadata());
        baseCrawlerMessage.setDataSourceDetails(message.getDataSourceDetails());
        baseCrawlerMessage.setDataKey(dataKey);
        return baseCrawlerMessage;
    }

    @Override
    public void execute() throws CrawlerWorkException {
        if (!this.isValid()) {
            logger.debug("message - {} is not valid.", (Object)this.message.toString());
            return;
        }
        CrawledDataWrappedResponse<R> response = this.processMessage();
        if (this instanceof Paginated) {
            this.handlePagination(response);
        }
    }

    private void handlePagination(CrawledDataWrappedResponse<R> response) throws CrawlerWorkException {
        BaseCrawlerMessage m;
        if (response.getEntity() instanceof PaginatedResponse && ((PaginatedResponse)response.getEntity()).hasNext() && null != (m = this.newMessage())) {
            this.crawler.sendCrawlerTaskMessage(m);
        }
    }

    protected List<String> filterFromEnvironment(String key) {
        if (null == System.getenv(key)) {
            return Collections.emptyList();
        }
        return Arrays.stream(System.getenv(key).split(",")).filter(s -> s != null && !s.isEmpty()).map(String::trim).collect(Collectors.toList());
    }

    protected boolean filter(List<String> filterValues, String value) {
        return filterValues == null || filterValues.isEmpty() || filterValues.contains(value);
    }

    protected List filters(String key) {
        List filterValues = this.crawler.getFilterValues(key);
        if (null == filterValues) {
            return Collections.emptyList();
        }
        return filterValues;
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        return null;
    }

    protected abstract CrawledDataWrappedResponse<R> processMessage() throws CrawlerWorkException;

    protected boolean isValid() {
        return true;
    }
}

