/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers;

import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.api.IngestionHttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerExecutor {
    private static final long TERMINATION_TIMEOUT_SECONDS = 30L;
    private static Logger logger = LoggerFactory.getLogger(CrawlerExecutor.class);
    private List<AbstractCrawler> crawlers = new ArrayList<AbstractCrawler>();
    private ExecutorService executorService;

    public CrawlerExecutor(Supplier<? extends AbstractCrawler> crawlerSupplier) {
        int threads = AgathaConfiguration.getCrawlerThreads();
        for (int i = 0; i < threads; ++i) {
            this.crawlers.add(crawlerSupplier.get());
        }
        this.executorService = Executors.newFixedThreadPool(threads);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Got shutdown hook");
            for (AbstractCrawler cr : this.crawlers) {
                cr.stop();
            }
            IngestionHttpClient.shutdown();
            this.executorService.shutdown();
            try {
                boolean terminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                if (terminated) {
                    logger.info("Thread pool terminated gracefully");
                } else {
                    logger.info("Thread pool did not terminate gracefully, going to kill it");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread was interrupted", e);
            }
        }));
    }

    public void execute() {
        this.crawlers.forEach(crawler -> this.executorService.execute((Runnable)crawler));
    }
}

