/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinscommons;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinscommons.messages.JenkinsJobMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.shared.grpc.services.ingest.ProbeResultMetadata;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJenkinsCrawler<M extends CrawlerMessage<M>>
extends AbstractHttpCrawler<M> {
    private static final Logger logger = LoggerFactory.getLogger(BaseJenkinsCrawler.class);

    public BaseJenkinsCrawler(String pluginId) {
        super(pluginId, AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected <C extends BaseJenkinsCrawler> CrawlerJobResult crawlItem(CrawlResolver<C, M> crawlResolver, C crawler, CrawlerJobWrapper<M> crawlerJob) {
        try {
            CrawlService crawl = crawlResolver.resolve(crawler, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProbeResultMetadata.Builder probe(CrawlerJobWrapper<M> crawlerJob) {
        Request request;
        ProbeResultMetadata.Builder resultBuilder = ProbeResultMetadata.newBuilder().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            request = new Request.Builder().url(new URL(this.getEndpoint(), "api/json?tree=nodeName")).build();
        }
        catch (MalformedURLException e) {
            logger.warn("Cannot construct Jenkins probe URL!");
            return resultBuilder.setIsSuccess(false).setReason(e.getMessage());
        }
        try (Response response = ((OkHttpClient)this.getClient()).newCall(request).execute();){
            if (response.isSuccessful()) {
                ProbeResultMetadata.Builder builder2 = resultBuilder.setIsSuccess(true);
                return builder2;
            }
            logger.warn("Jenkins probe was not successful for user: {}", (Object)this.username);
            ProbeResultMetadata.Builder builder = resultBuilder.setIsSuccess(false).setReason("Status: " + response.code());
            return builder;
        }
        catch (IOException e) {
            logger.warn("Jenkins probe was not successful for user: {}", (Object)this.username);
            return resultBuilder.setIsSuccess(false).setReason(e.getMessage());
        }
    }

    public <V extends JenkinsJobMessage> V generateNewMessage(Class<V> cls, JenkinsJobMessage oldMsg) throws IllegalAccessException, InstantiationException {
        JenkinsJobMessage newMsg = (JenkinsJobMessage)super.generateNewMessage(cls, (CrawlerMessage)oldMsg);
        newMsg.setBaseUrl(oldMsg.getBaseUrl());
        newMsg.setUrl(oldMsg.getUrl());
        newMsg.setName(oldMsg.getName());
        return (V)((Object)newMsg);
    }
}

