/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinscommons;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinscommons.messages.JenkinsJobMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobResult;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobWrapper;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.crawlers.shared.components.CrawlResolver;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.agatha.crawlers.shared.utils.ProbeUtils;
import com.xebialabs.agatha.shared.grpc.services.ingest.ProbeResultMetadata;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJenkinsCrawler<M extends CrawlerMessage<M>>
extends AbstractHttpCrawler<M> {
    private static final Logger logger = LoggerFactory.getLogger(BaseJenkinsCrawler.class);

    public BaseJenkinsCrawler(String pluginId) {
        super(pluginId, AbstractHttpCrawler.AuthenticationTypes.AUTH_USERNAME_PASSWORD);
    }

    protected ObjectMapper createMapper() {
        ObjectMapper mapper = super.createMapper();
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    protected <C extends BaseJenkinsCrawler> CrawlerJobResult crawlItem(CrawlResolver<C, M> crawlResolver, C crawler, CrawlerJobWrapper<M> crawlerJob) {
        try {
            CrawlService crawl = crawlResolver.resolve(crawler, crawlerJob);
            crawl.execute();
            return CrawlerJobResult.success();
        }
        catch (CrawlerWorkException e) {
            return CrawlerJobResult.fail((String)e.getMessage());
        }
    }

    protected ProbeResultMetadata.Builder probe(CrawlerJobWrapper<M> crawlerJob) {
        Request request;
        ProbeResultMetadata.Builder resultBuilder = ProbeResultMetadata.newBuilder().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            request = new Request.Builder().url(new URL(this.getEndpoint(), "api/json?tree=nodeName")).build();
        }
        catch (MalformedURLException e) {
            logger.warn("Cannot construct Jenkins probe URL!");
            return resultBuilder.setIsSuccess(false).setReason(e.getMessage());
        }
        ProbeUtils.BasicProbeResult basicProbeResult = ProbeUtils.basicProbe((Request)request, (OkHttpClient)((OkHttpClient)this.getClient()));
        resultBuilder.setReason(basicProbeResult.getResult());
        if (basicProbeResult.isSuccess()) {
            logger.warn("Jenkins probe was successful for user: {}", (Object)this.username);
            resultBuilder.setIsSuccess(true);
        } else {
            logger.warn("Jenkins probe was not successful for user: {}", (Object)this.username);
            resultBuilder.setIsSuccess(false);
        }
        return resultBuilder;
    }

    public <V extends JenkinsJobMessage> V generateNewMessage(Class<V> cls, JenkinsJobMessage oldMsg) throws IllegalAccessException, InstantiationException {
        JenkinsJobMessage newMsg = (JenkinsJobMessage)super.generateNewMessage(cls, (CrawlerMessage)oldMsg);
        newMsg.setBaseUrl(oldMsg.getBaseUrl());
        newMsg.setUrl(oldMsg.getUrl());
        newMsg.setName(oldMsg.getName());
        return (V)((Object)newMsg);
    }
}

