/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.api;

import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpEntities;
import akka.http.javadsl.model.HttpEntity;
import akka.http.javadsl.model.HttpRequest;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.CrawlerInputStream;
import com.xebialabs.agatha.crawlers.api.IngestionApi;
import com.xebialabs.agatha.crawlers.api.IngestionHttpClient;
import com.xebialabs.impact.api.AckUmMessagesVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownResponseVM;
import com.xebialabs.impact.api.PullMessagesWithStreamingRequestVM;
import com.xebialabs.impact.api.PullMessagesWithStreamingResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMDataResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import com.xebialabs.impact.api.ReportCrawlerLogMessageRequestVM;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public class IngestionApiRestImpl
implements IngestionApi {
    private final ObjectMapper mapper;
    private final IngestionHttpClient httpClient;

    public IngestionApiRestImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        this.httpClient = new IngestionHttpClient();
    }

    @Override
    public PullMessagesWithStreamingResponseVM pullUMMessage(String pluginId, String networkId) throws IOException {
        PullMessagesWithStreamingRequestVM vm = new PullMessagesWithStreamingRequestVM().setN(1).setPluginId(pluginId).setTenantId(AgathaConfiguration.getTenantId()).setNetworkId(networkId);
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/pull-um-messages")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(vm));
        ByteString byteString = this.httpClient.syncRequest(httpRequest);
        String string = byteString.utf8String();
        return this.mapper.readValue(string, PullMessagesWithStreamingResponseVM.class);
    }

    @Override
    public void pushUMMessage(PushCrawlerUMMessagesRequestVM messages) throws IOException {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-um-messages")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(messages));
        this.httpClient.syncRequestReturnsResponse(httpRequest);
    }

    @Override
    public void ackUmMessages(AckUmMessagesVM acks) throws IOException {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/ack-um-messages")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(acks));
        this.httpClient.syncRequestReturnsResponse(httpRequest);
    }

    @Override
    public PushCrawlerUMDataResponseVM pushUMData(Map<String, Object> payload) throws IOException {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-um-data-with-streaming")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(payload));
        ByteString byteString = this.httpClient.syncRequest(httpRequest);
        return this.mapper.readValue(byteString.utf8String(), PushCrawlerUMDataResponseVM.class);
    }

    @Override
    public PushCrawlerUMDataResponseVM pushUMDataAsSource(Map<String, Object> payload, Reader reader) throws IOException {
        String json = this.mapper.writeValueAsString(payload);
        HttpEntity.Chunked chunked = HttpEntities.create((ContentType)ContentTypes.APPLICATION_JSON, StreamConverters.fromInputStream(() -> new CrawlerInputStream(json, reader)));
        HttpRequest httpRequest = HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-um-data-with-streaming")).withEntity(chunked);
        ByteString byteString = this.httpClient.syncRequest(httpRequest);
        return this.mapper.readValue(byteString.utf8String(), PushCrawlerUMDataResponseVM.class);
    }

    @Override
    public void pushProbeUmStatus(PushProbeUMStatusRequestVM pushProbeUMStatusRequestVM) throws IOException {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/push-probe-um-status")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(pushProbeUMStatusRequestVM));
        this.httpClient.syncRequestReturnsResponse(httpRequest);
    }

    @Override
    public CheckWhichUMArtefactsAreKnownResponseVM checkWhichUMArtefactsAreKnown(CheckWhichUMArtefactsAreKnownRequestVM request) throws IOException {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/check-which-um-artefacts-are-known")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(request));
        ByteString byteString = this.httpClient.syncRequest(httpRequest);
        return this.mapper.readValue(byteString.utf8String(), CheckWhichUMArtefactsAreKnownResponseVM.class);
    }

    @Override
    public void reportCrawlerLog(ReportCrawlerLogMessageRequestVM request) throws IOException {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.POST(IngestionHttpClient.ingestionUrl("/api/crawler/report-crawler-log")).withEntity((ContentType)ContentTypes.APPLICATION_JSON, this.mapper.writeValueAsBytes(request));
        this.httpClient.syncRequestReturnsResponse(httpRequest);
    }

    @Override
    public void shutdown() {
        IngestionApiRestImpl ingestionApiRestImpl = this;
        ingestionApiRestImpl.httpClient.shutdown();
    }
}

