/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.util.LoggerFactory;
import com.typesafe.sslconfig.util.NoDepsLogger;
import java.security.Security;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u0017\t\u00192+_:uK6\u001cuN\u001c4jOV\u0014\u0018\r^5p]*\u00111\u0001B\u0001\u0004gNd'BA\u0003\u0007\u0003%\u00198\u000f\\2p]\u001aLwM\u0003\u0002\b\u0011\u0005AA/\u001f9fg\u00064WMC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005AQn\u001b'pO\u001e,'\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005!Q\u000f^5m\u0013\tIbCA\u0007M_\u001e<WM\u001d$bGR|'/\u001f\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uy\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"B\n\u001b\u0001\u0004!\u0002bB\u0011\u0001\u0005\u0004%\tAI\u0001\u0007Y><w-\u001a:\u0016\u0003\r\u0002\"!\u0006\u0013\n\u0005\u00152\"\u0001\u0004(p\t\u0016\u00048\u000fT8hO\u0016\u0014\bBB\u0014\u0001A\u0003%1%A\u0004m_\u001e<WM\u001d\u0011\t\u000b%\u0002A\u0011\u0001\u0016\u0002\u0013\r|gNZ5hkJ,GCA\u0016/!\tiA&\u0003\u0002.\u001d\t!QK\\5u\u0011\u0015y\u0003\u00061\u00011\u0003\u0019\u0019wN\u001c4jOB\u0011a$M\u0005\u0003e\t\u0011\u0011cU*M\u0007>tg-[4TKR$\u0018N\\4t\u0011\u0015!\u0004\u0001\"\u00016\u0003q\u0019wN\u001c4jOV\u0014X-\u00168tC\u001a,'+\u001a8fO>$\u0018.\u0019;j_:$\"a\u000b\u001c\t\u000b]\u001a\u0004\u0019\u0001\u001d\u00021\u0005dGn\\<V]N\fg-\u001a*f]\u0016<w\u000e^5bi&|g\u000e\u0005\u0002\u000es%\u0011!H\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u0005\u001awN\u001c4jOV\u0014X-\u00117m_^dUmZ1ds\"+G\u000e\\8NKN\u001c\u0018mZ3t)\tYc\bC\u0003@w\u0001\u0007\u0001(\u0001\rbY2|w\u000fT3hC\u000eL\b*\u001a7m_6+7o]1hKNDQ!\u0011\u0001\u0005\u0002\t\u000b\u0001dY8oM&<WO]3DQ\u0016\u001c7NU3w_\u000e\fG/[8o)\tY3\tC\u0003E\u0001\u0002\u0007\u0001(A\bdQ\u0016\u001c7NU3w_\u000e\fG/[8o\u0011\u00151\u0005\u0001\"\u0001H\u0003=\u0019G.Z1s!J|\u0007/\u001a:uS\u0016\u001cH#A\u0016")
public class SystemConfiguration {
    private final NoDepsLogger logger;

    public NoDepsLogger logger() {
        return this.logger;
    }

    public void configure(SSLConfigSettings config) {
        config.loose().allowUnsafeRenegotiation().foreach((Function1 & java.io.Serializable & Serializable)allowUnsafeRenegotiation -> {
            this.configureUnsafeRenegotiation(BoxesRunTime.unboxToBoolean((Object)allowUnsafeRenegotiation));
            return BoxedUnit.UNIT;
        });
        config.loose().allowLegacyHelloMessages().foreach((Function1 & java.io.Serializable & Serializable)allowLegacyHelloMessages -> {
            this.configureAllowLegacyHelloMessages(BoxesRunTime.unboxToBoolean((Object)allowLegacyHelloMessages));
            return BoxedUnit.UNIT;
        });
        config.checkRevocation().foreach((Function1 & java.io.Serializable & Serializable)checkRevocation -> {
            this.configureCheckRevocation(BoxesRunTime.unboxToBoolean((Object)checkRevocation));
            return BoxedUnit.UNIT;
        });
    }

    public void configureUnsafeRenegotiation(boolean allowUnsafeRenegotiation) {
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", ((Object)BoxesRunTime.boxToBoolean((boolean)allowUnsafeRenegotiation)).toString());
        this.logger().debug(new StringBuilder(74).append("configureUnsafeRenegotiation: sun.security.ssl.allowUnsafeRenegotiation = ").append(((Object)BoxesRunTime.boxToBoolean((boolean)allowUnsafeRenegotiation)).toString()).toString());
    }

    public void configureAllowLegacyHelloMessages(boolean allowLegacyHelloMessages) {
        System.setProperty("sun.security.ssl.allowLegacyHelloMessages", ((Object)BoxesRunTime.boxToBoolean((boolean)allowLegacyHelloMessages)).toString());
        this.logger().debug(new StringBuilder(79).append("configureAllowLegacyHelloMessages: sun.security.ssl.allowLegacyHelloMessages = ").append(((Object)BoxesRunTime.boxToBoolean((boolean)allowLegacyHelloMessages)).toString()).toString());
    }

    public void configureCheckRevocation(boolean checkRevocation) {
        Security.setProperty("ocsp.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)checkRevocation)).toString());
        this.logger().debug(new StringBuilder(40).append("configureCheckRevocation: ocsp.enable = ").append(((Object)BoxesRunTime.boxToBoolean((boolean)checkRevocation)).toString()).toString());
        System.setProperty("com.sun.security.enableCRLDP", ((Object)BoxesRunTime.boxToBoolean((boolean)checkRevocation)).toString());
        this.logger().debug(new StringBuilder(57).append("configureCheckRevocation: com.sun.security.enableCRLDP = ").append(((Object)BoxesRunTime.boxToBoolean((boolean)checkRevocation)).toString()).toString());
        System.setProperty("com.sun.net.ssl.checkRevocation", ((Object)BoxesRunTime.boxToBoolean((boolean)checkRevocation)).toString());
    }

    public void clearProperties() {
        Security.setProperty("ocsp.enable", "false");
        System.clearProperty("com.sun.security.enableCRLDP");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("sun.security.ssl.allowLegacyHelloMessages");
        System.clearProperty("sun.security.ssl.allowUnsafeRenegotiation");
    }

    public SystemConfiguration(LoggerFactory mkLogger) {
        this.logger = mkLogger.apply(this.getClass());
    }
}

