/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jenkinsv1.services;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jenkinscommons.JenkinsURLHelper;
import com.xebialabs.agatha.crawlers.jenkinsv1.JenkinsCrawler;
import com.xebialabs.agatha.crawlers.jenkinsv1.messages.JenkinsFolderJobMessage;
import com.xebialabs.agatha.crawlers.jenkinsv1.models.JenkinsBaseEntity;
import com.xebialabs.agatha.crawlers.jenkinsv1.models.dtos.FolderResponse;
import com.xebialabs.agatha.crawlers.jenkinsv1.services.JenkinsBaseCrawl;
import com.xebialabs.agatha.crawlers.jenkinsv1.services.JenkinsJobCrawl;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsFolderJobCrawl
extends JenkinsBaseCrawl<JenkinsFolderJobMessage, FolderResponse> {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsJobCrawl.class);

    public JenkinsFolderJobCrawl(JenkinsCrawler crawler, JenkinsFolderJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    protected CrawledDataWrappedResponse<FolderResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process JenkinsFolderJobMessage for endpoint {}", (Object)((JenkinsFolderJobMessage)this.message).getUrl());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(FolderResponse.class, JenkinsURLHelper.apiUrl((String)((JenkinsFolderJobMessage)this.message).getUrl(), (String)"api/json?tree=name,jobs[name,url]"));
        this.handleResponse((CrawledDataWrappedResponse<FolderResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<FolderResponse> response) throws CrawlerWorkException {
        for (JenkinsBaseEntity jenkinsBaseEntity : ((FolderResponse)response.getEntity()).getJobs()) {
            if (!this.checkFilters(jenkinsBaseEntity)) continue;
            this.sendNextMessage(jenkinsBaseEntity, "0-job-");
        }
    }

    private boolean checkFilters(JenkinsBaseEntity job) {
        List jobNameRegexpList = this.filters("JOB_NAME_REGEXP");
        boolean hasSomething = false;
        for (String jobNameRegexpString : jobNameRegexpList) {
            String trimmed = jobNameRegexpString.trim();
            if (trimmed.isEmpty()) continue;
            hasSomething = true;
            if (!this.checkJobNameRegexp(jobNameRegexpString, job)) continue;
            return true;
        }
        return !hasSomething;
    }

    private boolean checkJobNameRegexp(String jobNameRegexpString, JenkinsBaseEntity job) {
        Pattern pattern = Pattern.compile(jobNameRegexpString);
        return pattern.matcher(job.getName()).find();
    }
}

