/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.jsonstreaming;

import com.xebialabs.agatha.jsonstreaming.ParserCore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

class Utf8Reader {
    private static final int MAX_UTF8_BYTES = 4;
    private Charset utf8 = Charset.forName("UTF-8");
    private byte[] leftCharacters = new byte[4];
    private int leftCharactersLength;
    private int leftCharacterCharLength;
    private byte[] utf8Buffer;
    private int utf8BufferSize;
    private int utf8BufferPosition;
    private char[] decodedCharBuffer = new char[0];
    private int decodedCharBufferLength;
    private ParserCore parser;

    public Utf8Reader(ParserCore parser) {
        this.parser = parser;
    }

    public void write(byte[] cbuf, int off, int len) throws IOException {
        if (this.leftCharactersLength > 0) {
            this.leftCharacterCharLength = this.getCharSize(this.leftCharacters[0]);
            int toCopy = this.leftCharacterCharLength - this.leftCharactersLength;
            System.arraycopy(cbuf, off, this.leftCharacters, this.leftCharactersLength, toCopy);
            off += toCopy;
            len -= toCopy;
            this.leftCharactersLength += toCopy;
            this.utf8Buffer = this.leftCharacters;
            this.utf8BufferSize = 1;
            this.utf8BufferPosition = 0;
            this.decodeAndProcess(true);
        }
        this.utf8Buffer = cbuf;
        this.utf8BufferSize = len;
        this.utf8BufferPosition = off;
        this.decodeAndProcess(false);
    }

    private void decodeAndProcess(boolean onlyOne) throws IOException {
        int utf8CharSizes;
        int n = utf8CharSizes = onlyOne ? this.leftCharacterCharLength : this.getAvailableCharSizes();
        if (!onlyOne) {
            this.leftCharactersLength = this.utf8BufferSize - utf8CharSizes;
            if (this.leftCharactersLength > 0) {
                System.arraycopy(this.utf8Buffer, this.utf8BufferPosition + utf8CharSizes, this.leftCharacters, 0, this.leftCharactersLength);
            }
        }
        CharBuffer decode = this.utf8.decode(ByteBuffer.wrap(this.utf8Buffer, this.utf8BufferPosition, utf8CharSizes));
        this.decodedCharBuffer = decode.array();
        this.decodedCharBufferLength = decode.length();
        this.utf8BufferPosition = 0;
        this.utf8BufferSize = 0;
        this.process();
    }

    private void process() throws IOException {
        this.parser.onDataAvailable(this.decodedCharBuffer, this.decodedCharBufferLength);
    }

    private int getAvailableCharSizes() throws IOException {
        if (this.utf8BufferSize == 0) {
            return 0;
        }
        int finish = this.utf8BufferPosition + this.utf8BufferSize;
        while ((this.utf8Buffer[finish - 1] & 0xC0) == 128) {
            --finish;
        }
        int extra = this.getCharSize(this.utf8Buffer[finish - 1]) - 1;
        finish = this.utf8BufferPosition + this.utf8BufferSize >= finish + extra ? (finish += extra) : --finish;
        return finish - this.utf8BufferPosition;
    }

    private int getCharSize(byte b) throws IOException {
        if ((b & 0xF8) == 240) {
            return 4;
        }
        if ((b & 0xF0) == 224) {
            return 3;
        }
        if ((b & 0xE0) == 192) {
            return 2;
        }
        if ((b & 0x80) == 0) {
            return 1;
        }
        throw new IOException("invalid utf8 byte: [" + Integer.toString(b, 16) + "]");
    }

    public boolean hasLeftCharacters() {
        return this.leftCharactersLength > 0;
    }
}

