/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.components.helpers;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.HttpUrl;

public class JiraUrlHelper {
    private JiraUrlHelper() {
    }

    public static URL probeUrl(URL endpoint) throws CrawlerWorkException {
        return JiraUrlHelper.base(endpoint.toString()).addPathSegment("search").addQueryParameter("maxResults", "1").build().url();
    }

    public static URL issuesURL(URL endpoint, int yearsBack, int maxResults, int startAt, String updatedGreaterThan) throws CrawlerWorkException {
        URL url = JiraUrlHelper.base(endpoint.toString()).addPathSegment("search").addQueryParameter("fields", "updated").addQueryParameter("maxResults", Integer.toString(maxResults)).addQueryParameter("startAt", Integer.toString(startAt)).build().url();
        return HttpUrl.parse((String)(url + String.format("&jql=%s", JiraUrlHelper.makeJql(yearsBack, updatedGreaterThan)))).url();
    }

    public static URL issueURL(String endPoint) {
        return HttpUrl.parse((String)endPoint).newBuilder().addQueryParameter("expand", "versionedRepresentations").build().url();
    }

    public static URL fieldURL(URL endpoint) throws CrawlerWorkException {
        return JiraUrlHelper.base(endpoint.toString()).addPathSegment("field").build().url();
    }

    private static String yearsBack(int yearsBack) {
        int weeks = yearsBack * 52;
        return String.format("updatedDate >= -%dw ORDER BY updated", weeks);
    }

    private static URL getURL(String endPoint) throws CrawlerWorkException {
        try {
            return new URL(endPoint);
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private static HttpUrl.Builder base(String endPoint) throws CrawlerWorkException {
        if (endPoint != null && !endPoint.isEmpty()) {
            URL baseURL = JiraUrlHelper.getURL(endPoint);
            HttpUrl.Builder builder = new HttpUrl.Builder().scheme(baseURL.getProtocol()).host(baseURL.getHost());
            String path = baseURL.getPath();
            while (path.contains("/")) {
                String segment = path.substring(0, path.indexOf(47));
                if (!segment.isEmpty()) {
                    builder.addPathSegment(segment);
                }
                path = path.substring(segment.length() + 1, path.length());
            }
            if (!path.isEmpty()) {
                builder.addPathSegment(path);
            }
            builder.addPathSegment("rest").addPathSegment("api").addPathSegment("latest");
            if (baseURL.getPort() != -1) {
                builder.port(baseURL.getPort());
            }
            return builder;
        }
        throw new CrawlerWorkException("Base URL can not be empty or null.");
    }

    private static String makeJql(int yearsToCrawl, String updatedGreaterThan) {
        StringBuilder jql = new StringBuilder();
        String condition = updatedGreaterThan == null || updatedGreaterThan.isEmpty() ? "" : "(updated < \"" + updatedGreaterThan + "\")";
        jql.append(condition);
        if (!condition.isEmpty()) {
            jql.append(" AND ");
        }
        jql.append(JiraUrlHelper.yearsBack(yearsToCrawl));
        return jql.toString();
    }
}

