/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.services.probe;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.components.helpers.JiraUrlHelper;
import com.xebialabs.agatha.crawlers.jira.models.dtos.IssuesResponse;
import com.xebialabs.agatha.crawlers.jira.services.probe.ProbeService;
import com.xebialabs.impact.api.ProbeResultMetadataVM;
import java.io.IOException;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbServiceImpl
implements ProbeService {
    private final URL endpoint;
    private final String username;
    private final ObjectMapper mapper;
    private final OkHttpClient client;
    private static final Logger logger = LoggerFactory.getLogger(ProbServiceImpl.class);

    public ProbServiceImpl(URL endpoint, String username, ObjectMapper mapper, OkHttpClient client) {
        this.endpoint = endpoint;
        this.username = username;
        this.mapper = mapper;
        this.client = client;
    }

    @Override
    public ProbeResultMetadataVM probeOnIssue() {
        ProbeResultMetadataVM resultBuilder = new ProbeResultMetadataVM().setEndpoint(this.endpoint.toString()).setUsername(this.username);
        try {
            Response response = this.response();
            if (response.isSuccessful()) {
                return this.hasIssues(response, resultBuilder);
            }
            logger.warn("Jira probe was not successful for user/org: {}", (Object)this.username);
            return resultBuilder.setSuccess(false).setReason("Status: " + response.code());
        }
        catch (CrawlerWorkException e) {
            return resultBuilder.setSuccess(false).setReason(e.getMessage());
        }
    }

    private ProbeResultMetadataVM hasIssues(Response response, ProbeResultMetadataVM resultBuilder) throws CrawlerWorkException {
        try {
            boolean containsIssues;
            IssuesResponse issuesResponse = (IssuesResponse)this.mapper.readValue(response.body().string(), IssuesResponse.class);
            boolean bl = containsIssues = issuesResponse.getValues() != null && !issuesResponse.getValues().isEmpty();
            if (containsIssues) {
                logger.info("Probe success! Got single ticket: {}", (Object)issuesResponse.getValues().get(0).getId());
                resultBuilder.setSuccess(true);
                return resultBuilder;
            }
            logger.warn("Can connect to Jira but got no tickets, which is unexpected");
            resultBuilder.setSuccess(false).setReason("Got no tickets from Jira");
            return resultBuilder;
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private Response response() throws CrawlerWorkException {
        try {
            return this.client.newCall(this.request()).execute();
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private Request request() throws CrawlerWorkException {
        return new Request.Builder().url(JiraUrlHelper.probeUrl(this.endpoint)).build();
    }
}

