/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.services.crawl;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.components.helpers.JiraUrlHelper;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssueCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssuesCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.models.dtos.IssuesResponse;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraBaseCrawl;
import com.xebialabs.agatha.crawlers.jira.services.crawl.OverlappingCrawl;
import com.xebialabs.agatha.crawlers.jira.utils.JiraUtils;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIssuesCrawl
extends JiraBaseCrawl<JiraIssuesCrawlMessage>
implements OverlappingCrawl<JiraIssuesCrawlMessage, IssuesResponse, Issue> {
    private static final Logger logger = LoggerFactory.getLogger(JiraIssuesCrawl.class);
    private static final DateTimeFormatter issueDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm");

    public JiraIssuesCrawl(JiraCrawler crawler, JiraIssuesCrawlMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    public void execute() throws CrawlerWorkException {
        logger.debug("Process JiraIssuesCrawlMessage for endpoint {} ", (Object)((JiraIssuesCrawlMessage)this.message).getBaseUrl());
        CrawledDataWrappedResponse crawlResponse = this.responseFetcher.fetchEntity(IssuesResponse.class, this.issuesURL());
        if (JiraIssuesCrawl.isEmpty(crawlResponse)) {
            return;
        }
        if (((JiraIssuesCrawlMessage)this.message).getStartAt() > 0 && !((JiraIssuesCrawlMessage)this.message).getOverLappingEntityId().equals(((IssuesResponse)crawlResponse.getEntity()).getFirst().getId())) {
            this.sendMessageWhenOverlappingNotEqual((JiraIssuesCrawlMessage)this.message);
            return;
        }
        int matchingVersions = 0;
        for (Issue issue : ((IssuesResponse)crawlResponse.getEntity()).getValues()) {
            boolean isNotKnown = this.sendIssueJobMessage(issue);
            matchingVersions += isNotKnown ? 0 : 1;
        }
        this.handleNextMessage((JiraIssuesCrawlMessage)this.message, (IssuesResponse)crawlResponse.getEntity(), matchingVersions);
    }

    private boolean sendIssueJobMessage(Issue issue) throws CrawlerWorkException {
        try {
            boolean isNonKnown = this.crawler.decideToContinueBeforeCrawling(this.dataMessage, JiraUtils.value(issue, "updated"), issue.getId(), DataSourceTypeEnum.TICKET);
            if (isNonKnown) {
                JiraIssueCrawlMessage jiraIssueCrawlMessage = ((JiraIssueCrawlMessage)this.crawler.generateNewMessage(JiraIssueCrawlMessage.class, this.message)).setId(issue.getId()).setUrl(issue.getSelf());
                jiraIssueCrawlMessage.setDataKey(JiraIssueCrawlMessage.class.getSimpleName());
                this.crawler.sendCrawlerTaskMessage(jiraIssueCrawlMessage);
            }
            return isNonKnown;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    public JiraIssuesCrawlMessage newMessage() throws CrawlerWorkException {
        try {
            JiraIssuesCrawlMessage jiraIssuesCrawlMessage = (JiraIssuesCrawlMessage)this.crawler.generateNewMessage(JiraIssuesCrawlMessage.class, this.message);
            jiraIssuesCrawlMessage.setDataKey(((Object)((Object)jiraIssuesCrawlMessage)).getClass().getSimpleName());
            return jiraIssuesCrawlMessage;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private URL issuesURL() throws CrawlerWorkException {
        return JiraUrlHelper.issuesURL(this.crawler.getEndpoint(), this.crawler.getYearsBack(), ((JiraIssuesCrawlMessage)this.message).getMaxResults(), ((JiraIssuesCrawlMessage)this.message).getStartAt(), ((JiraIssuesCrawlMessage)this.message).getLastUpdatedDate());
    }

    @Override
    public String lastUpdatedDate(IssuesResponse response) {
        List values = response.getValues().stream().map(issue -> issue.getFields().getFields().get("updated")).map(DateTime::new).distinct().sorted().collect(Collectors.toList());
        if (values.size() < 2) {
            return "";
        }
        return issueDateFormatter.print((ReadableInstant)((DateTime)values.get(1)).toDateTime(DateTimeZone.UTC));
    }

    @Override
    public void sendMessageWhenOverlappingNotEqual(JiraIssuesCrawlMessage message) throws CrawlerWorkException {
        JiraIssuesCrawlMessage newMessage = this.newMessage();
        logger.debug("Overlapping issue ID mismatched, retrying issue crawling with start at {}", (Object)(message.getStartAt() - 1));
        newMessage.setStartAt(message.getStartAt() - 1).setOverLappingEntityId(message.getOverLappingEntityId()).setMaxResults(message.getMaxResults()).setLastUpdatedDate(message.getLastUpdatedDate());
        logger.debug("Send message when overlapping not same - overlapping id - {}, offset - {}, lastUpdatedDate - {}, limit - {} message - {} ", new Object[]{message.getOverLappingEntityId(), message.getStartAt() - 1, message.getLastUpdatedDate(), message.getMaxResults(), ((Object)((Object)newMessage)).getClass().getSimpleName()});
        this.crawler.sendCrawlerTaskMessage(newMessage);
    }

    @Override
    public void sendMessageWithGreaterMaxLimit(JiraIssuesCrawlMessage message) throws CrawlerWorkException {
        JiraIssuesCrawlMessage newMessage = this.newMessage();
        newMessage.setStartAt(0).setMaxResults(message.getMaxResults() + 10);
        logger.debug("Send message with greater max limit with overlapping id - {}, limit - {} message - {} ", new Object[]{message.getOverLappingEntityId(), message.getMaxResults() + 10, ((Object)((Object)newMessage)).getClass().getSimpleName()});
        this.crawler.sendCrawlerTaskMessage(newMessage);
    }

    @Override
    public void handleNextMessage(JiraIssuesCrawlMessage message, IssuesResponse response, int matchedVersions) throws CrawlerWorkException {
        if (message.getLastUpdatedDate() == null || message.getLastUpdatedDate().isEmpty()) {
            String updatedLessThan = this.lastUpdatedDate(response);
            if (updatedLessThan.isEmpty()) {
                this.sendMessageWithGreaterMaxLimit(message);
            } else {
                this.sendMessageWithLastUpdatedDate(updatedLessThan);
            }
            return;
        }
        if (message.getStartAt() == 0) {
            matchedVersions = 0;
        }
        logger.info("{} issues of {} match known [updated] value", (Object)matchedVersions, (Object)response.getValues().size());
        int size = response.getValues().size();
        if (!(message.getMaxResults() != size || message.getMetadata().isIncremental() && matchedVersions >= size)) {
            this.sendNextPageMessage(message, response);
        }
    }

    @Override
    public void sendNextPageMessage(JiraIssuesCrawlMessage message, IssuesResponse response) throws CrawlerWorkException {
        int nextStartAt = message.getStartAt() + response.getValues().size() - 1;
        JiraIssuesCrawlMessage newMessage = this.newMessage();
        newMessage.setOverLappingEntityId(response.getLast().getId()).setStartAt(nextStartAt).setLastUpdatedDate(message.getLastUpdatedDate());
        logger.debug("Send Next Page message with overlapping id - {}, offset - {} message - {} ", new Object[]{response.getLast().getId(), nextStartAt, ((Object)((Object)newMessage)).getClass().getSimpleName()});
        this.crawler.sendCrawlerTaskMessage(newMessage);
    }

    @Override
    public void sendMessageWithLastUpdatedDate(String updatedLessThan) throws CrawlerWorkException {
        JiraIssuesCrawlMessage newMessage = this.newMessage();
        newMessage.setStartAt(0).setLastUpdatedDate(updatedLessThan);
        logger.debug("Send Message with lastupdateddate - {} message - {} ", (Object)updatedLessThan, (Object)((Object)((Object)newMessage)).getClass().getSimpleName());
        this.crawler.sendCrawlerTaskMessage(newMessage);
    }
}

