/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.um.converters;

import com.xebialabs.agatha.crawlers.jira.models.FieldModel;
import com.xebialabs.agatha.crawlers.jira.um.converters.JiraUMConverter;
import com.xebialabs.agatha.crawlers.shared.PluginConstants;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldConverter
extends JiraUMConverter<Map<String, Object>, List<FieldModel>> {
    public FieldConverter(String pluginId, String pluginVersion, String type, String typeVersion) {
        super(type, typeVersion, pluginId, pluginVersion, DataSourceTypeEnum.FIELDS);
    }

    @Override
    public Map<String, Object> transform(List<FieldModel> entity) {
        HashMap fields = new HashMap();
        for (FieldModel fieldModel : entity) {
            if (!this.isCustomField(fieldModel)) continue;
            HashMap<String, Object> fieldValue = new HashMap<String, Object>();
            HashMap<String, String> title = new HashMap<String, String>();
            title.put("displayName", fieldModel.getName());
            fieldValue.put("type", this.schemaType(fieldModel));
            fieldValue.put("title", title);
            fields.put(fieldModel.getId(), fieldValue);
        }
        HashMap<String, Object> fieldsWrapper = new HashMap<String, Object>();
        fieldsWrapper.put("fields", fields);
        return fieldsWrapper;
    }

    private boolean isCustomField(FieldModel fieldModel) {
        return fieldModel.getId() != null && fieldModel.getId().trim().toLowerCase().startsWith("customfield_");
    }

    private String schemaType(FieldModel fieldModel) {
        if (fieldModel.getSchema() == null || fieldModel.getSchema().getType() == null) {
            return PluginConstants.FieldType.STRING_NOT_ANALYZED.getName();
        }
        switch (fieldModel.getSchema().getType().toLowerCase()) {
            case "number": {
                return PluginConstants.FieldType.DOUBLE.getName();
            }
            case "array": {
                return PluginConstants.FieldType.MULTI_SELECT.getName();
            }
            case "datetime": {
                return PluginConstants.FieldType.LONG.getName();
            }
            case "date": {
                return PluginConstants.FieldType.LONG.getName();
            }
        }
        return PluginConstants.FieldType.STRING_NOT_ANALYZED.getName();
    }
}

