/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.um.aggregators;

import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.um.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.jira.utils.JiraUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SystemFieldsAggregator
implements Aggregator {
    private final String storyPointsField;

    public SystemFieldsAggregator(String storyPointsField) {
        this.storyPointsField = storyPointsField;
    }

    @Override
    public void populate(Ticket ticket, Issue issue) {
        ticket.setId(issue.getId());
        ticket.setVersion(JiraUtils.valueAsLong(issue.getVersionedRepresentations(), "updated_1"));
        ticket.setStartMs(JiraUtils.valueAsLong(issue.getVersionedRepresentations(), "created_1"));
        ticket.setTitle(JiraUtils.value(issue, "summary_1"));
        ticket.setTicketType(JiraUtils.value(issue, "issuetype_1_name"));
        ticket.setStatus(JiraUtils.value(issue, "status_1_name"));
        ticket.setAssignee(JiraUtils.value(issue, "assignee_1_name"));
        ticket.setPriority(JiraUtils.value(issue, "priority_1_name"));
        this.labels(issue, ticket);
        this.components(issue, ticket);
        this.affectVersions(issue, ticket);
        this.storyPoints(ticket, issue);
        this.parentRelations(issue, ticket);
    }

    private void storyPoints(Ticket ticket, Issue issue) {
        if (this.storyPointsField == null) {
            return;
        }
        Object storyPoints = JiraUtils.valueForKey(issue.getVersionedRepresentations().getProperties(), String.format("%s-1-value", this.storyPointsField), 0, "-");
        ticket.setStoryPoints(storyPoints == null ? null : storyPoints.toString());
    }

    private void parentRelations(Issue entity, Ticket ticket) {
        if (entity.getKey() != null && !entity.getKey().isEmpty()) {
            HashMap<String, String> relations = new HashMap<String, String>();
            relations.put("issueKey", entity.getKey());
            Ticket.Other other = new Ticket.Other(relations);
            ticket.setOther(other);
        }
    }

    private void labels(Issue entity, Ticket ticket) {
        Object value = JiraUtils.valueForKey(entity.getVersionedRepresentations().getProperties(), "labels_1", 0, "_");
        if (value != null && value instanceof List) {
            List labels = (List)value;
            ticket.setLabels(labels);
        }
    }

    private void components(Issue entity, Ticket ticket) {
        Object value = JiraUtils.valueForKey(entity.getVersionedRepresentations().getProperties(), "components_1", 0, "_");
        if (value != null && value instanceof List) {
            List labels = (List)value;
            List<String> extractedComponentNames = labels.stream().map(map -> map.getOrDefault("name", null)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            ticket.setComponents(extractedComponentNames);
        }
    }

    private void affectVersions(Issue entity, Ticket ticket) {
        Object value = JiraUtils.valueForKey(entity.getVersionedRepresentations().getProperties(), "versions_1", 0, "_");
        if (value != null && value instanceof List) {
            List labels = (List)value;
            List<String> versionNames = labels.stream().map(stringObjectMap -> stringObjectMap.getOrDefault("name", null)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            ticket.setAffectVersions(versionNames);
        }
    }
}

