/*
 * Decompiled with CFR 0.152.
 */
package akka.http.javadsl.server;

import akka.Done;
import akka.actor.ActorSystem;
import akka.annotation.ApiMayChange;
import akka.event.Logging;
import akka.http.javadsl.ConnectHttp;
import akka.http.javadsl.Http;
import akka.http.javadsl.ServerBinding;
import akka.http.javadsl.server.AllDirectives;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.settings.ServerSettings;
import akka.stream.ActorMaterializer;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

@ApiMayChange
public abstract class HttpApp
extends AllDirectives {
    private AtomicReference<ServerBinding> serverBinding = new AtomicReference();
    protected AtomicReference<ActorSystem> systemReference = new AtomicReference();

    public void startServer(String string, int n) throws ExecutionException, InterruptedException {
        this.startServer(string, n, ServerSettings.create(ConfigFactory.load()));
    }

    public void startServer(String string, int n, ActorSystem actorSystem) throws ExecutionException, InterruptedException {
        this.startServer(string, n, ServerSettings.create(actorSystem), Optional.ofNullable(actorSystem));
    }

    public void startServer(String string, int n, ServerSettings serverSettings) throws ExecutionException, InterruptedException {
        this.startServer(string, n, serverSettings, Optional.empty());
    }

    public void startServer(String string, int n, ServerSettings serverSettings, ActorSystem actorSystem) throws ExecutionException, InterruptedException {
        this.startServer(string, n, serverSettings, Optional.ofNullable(actorSystem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(String string, int n, ServerSettings serverSettings, Optional<ActorSystem> optional) throws ExecutionException, InterruptedException {
        ActorSystem actorSystem = optional.orElseGet(() -> ActorSystem.create(Logging.simpleName(this).replaceAll("\\$", "")));
        this.systemReference.set(actorSystem);
        ActorMaterializer actorMaterializer = ActorMaterializer.create(actorSystem);
        CompletionStage<ServerBinding> completionStage = Http.get(actorSystem).bindAndHandle(this.routes().flow(actorSystem, actorMaterializer), ConnectHttp.toHost(string, n), serverSettings, actorSystem.log(), actorMaterializer);
        completionStage.handle((serverBinding, throwable) -> {
            if (throwable != null) {
                this.postHttpBindingFailure((Throwable)throwable);
            } else {
                this.serverBinding.set((ServerBinding)serverBinding);
                this.postHttpBinding((ServerBinding)serverBinding);
            }
            return null;
        });
        try {
            ((CompletableFuture)completionStage.thenCompose(serverBinding -> this.waitForShutdownSignal(actorSystem)).toCompletableFuture().exceptionally(throwable -> Done.getInstance())).get();
        }
        finally {
            completionStage.thenCompose(ServerBinding::unbind).handle((done, throwable) -> {
                this.postServerShutdown(Optional.ofNullable(throwable), actorSystem);
                if (!optional.isPresent()) {
                    actorSystem.terminate();
                }
                return null;
            });
        }
    }

    ServerBinding binding() {
        if (this.serverBinding.get() == null) {
            throw new IllegalStateException("Binding not yet stored. Have you called startServer?");
        }
        return this.serverBinding.get();
    }

    protected void postServerShutdown(Optional<Throwable> optional, ActorSystem actorSystem) {
        this.systemReference.get().log().info("Shutting down the server");
    }

    protected void postHttpBinding(ServerBinding serverBinding) {
        this.systemReference.get().log().info("Server online at http://" + serverBinding.localAddress().getHostName() + ":" + serverBinding.localAddress().getPort() + "/");
    }

    protected void postHttpBindingFailure(Throwable throwable) {
        this.systemReference.get().log().error(throwable, "Error starting the server: " + throwable.getMessage());
    }

    protected CompletionStage<Done> waitForShutdownSignal(ActorSystem actorSystem) {
        CompletableFuture<Done> completableFuture = new CompletableFuture<Done>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> completableFuture.complete(Done.getInstance())));
        CompletableFuture.runAsync(() -> {
            System.out.println("Press RETURN to stop...");
            try {
                if (System.in.read() >= 0) {
                    completableFuture.complete(Done.getInstance());
                }
            }
            catch (IOException iOException) {
                this.systemReference.get().log().error(iOException, "Problem occurred! " + iOException.getMessage());
            }
        });
        return completableFuture;
    }

    protected abstract Route routes();
}

