/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.services.crawl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.components.helpers.JiraUrlHelper;
import com.xebialabs.agatha.crawlers.jira.messages.JiraFieldsCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssuesCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.models.FieldModel;
import com.xebialabs.agatha.crawlers.jira.models.dtos.FieldsResponse;
import com.xebialabs.agatha.crawlers.jira.repository.FieldsRepository;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraBaseCrawl;
import com.xebialabs.agatha.crawlers.jira.um.converters.FieldConverter;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class JiraFieldsCrawl
extends JiraBaseCrawl<JiraFieldsCrawlMessage> {
    private final UMConverter<Map<String, Object>, List<FieldModel>> umConvertible;
    private final KeyValueRepository<Map<String, Object>> repository;

    public JiraFieldsCrawl(JiraCrawler crawler, JiraFieldsCrawlMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.umConvertible = new FieldConverter(message.getPluginId(), "v1", "FIELDS", "v1");
        this.repository = new FieldsRepository(crawler, dataMessage);
    }

    public void execute() throws CrawlerWorkException {
        URL fieldURL = JiraUrlHelper.fieldURL(this.crawler.getEndpoint());
        CrawledDataWrappedResponse<FieldsResponse> response = this.responseFetcher.wrappedListResponse(fieldURL, new TypeReference<List<FieldModel>>(){}, FieldsResponse.class);
        if (JiraFieldsCrawl.isEmpty(response)) {
            return;
        }
        this.save(response);
        this.initIssuesCrawl();
    }

    private void initIssuesCrawl() throws CrawlerWorkException {
        this.startCrawlTask(JiraIssuesCrawlMessage.class);
    }

    private void save(CrawledDataWrappedResponse<FieldsResponse> response) throws CrawlerWorkException {
        UMWrappedEntity umData = this.umConvertible.convert(((FieldsResponse)response.getEntity()).getValues());
        this.repository.save(umData);
    }
}

