/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.um.aggregators;

import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.um.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.jira.utils.JiraUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AdditionalFieldsAggregator
implements Aggregator {
    @Override
    public void populate(Ticket ticket, Issue issue) {
        if (this.isEmpty(issue)) {
            return;
        }
        Map<String, Object> additionalFields = this.additionalFields(issue);
        ticket.setAdditionalFields(additionalFields);
    }

    private Map<String, Object> additionalFields(Issue issue) {
        Map<String, Object> fields = issue.getVersionedRepresentations().getProperties();
        HashMap<String, Object> additionalFields = new HashMap<String, Object>();
        additionalFields.put("key", issue.getKey());
        additionalFields.put("creator_display_name", JiraUtils.valueForKey(fields, "creator_1_displayName", 0, "_"));
        additionalFields.put("reporter_display_name", JiraUtils.valueForKey(fields, "reporter_1_displayName", 0, "_"));
        additionalFields.put("fix_versions", this.fixVersions(fields));
        additionalFields.put("project_key", JiraUtils.valueForKey(fields, "project-1-key", 0, "-"));
        additionalFields.put("time_spent", JiraUtils.valueForKey(fields, "timespent-1", 0, "-"));
        additionalFields.put("resolution", JiraUtils.valueForKey(fields, "resolution-1-name", 0, "-"));
        additionalFields.put("resolution_date", this.date(fields, "resolutiondate-1"));
        additionalFields.put("work_ratio", JiraUtils.valueForKey(fields, "workratio-1", 0, "-"));
        additionalFields.put("time_estimate", JiraUtils.valueForKey(fields, "timeestimate-1", 0, "-"));
        additionalFields.put("aggregate_time_original_estimate", JiraUtils.valueForKey(fields, "aggregatetimeorignalestimate-1", 0, "-"));
        additionalFields.put("updated", this.date(fields, "updated-1"));
        additionalFields.put("time_original_estimate", JiraUtils.valueForKey(fields, "timeorignalestimate-1", 0, "-"));
        additionalFields.put("description", JiraUtils.valueForKey(fields, "description-1", 0, "-"));
        additionalFields.put("security", JiraUtils.valueForKey(fields, "security-1", 0, "-"));
        additionalFields.put("aggregate_time_estimate", JiraUtils.valueForKey(fields, "aggregatetimeestimate-1", 0, "-"));
        additionalFields.put("environment", JiraUtils.valueForKey(fields, "environment-1", 0, "-"));
        additionalFields.put("due_date", JiraUtils.valueForKey(fields, "duedate-1", 0, "-"));
        additionalFields.put("votes", JiraUtils.valueForKey(fields, "votes-1-votes", 0, "-"));
        return additionalFields;
    }

    private Long date(Map<String, Object> fields, String key) {
        Object value = JiraUtils.valueForKey(fields, key, 0, "-");
        return value != null ? JiraUtils.dateAsLong(value.toString()) : null;
    }

    private List<String> fixVersions(Map<String, Object> fields) {
        Object value = JiraUtils.valueForKey(fields, "fixVersions_1", 0, "_");
        if (value != null && value instanceof List) {
            List labels = (List)value;
            return labels.stream().map(stringObjectMap -> stringObjectMap.getOrDefault("name", null)).filter(name -> name != null).map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }
}

