/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.services.crawl;

import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.components.helpers.JiraUrlHelper;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssueCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.repository.TicketRepository;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraBaseCrawl;
import com.xebialabs.agatha.crawlers.jira.um.converters.IssueConverter;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIssueCrawl
extends JiraBaseCrawl<JiraIssueCrawlMessage> {
    private static final Logger logger = LoggerFactory.getLogger(JiraIssueCrawl.class);
    private final UMConverter<Ticket, Issue> umConvertible;
    private final KeyValueRepository<Ticket> repository;

    public JiraIssueCrawl(JiraCrawler crawler, JiraIssueCrawlMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.umConvertible = new IssueConverter(message.getPluginId(), "v1", "TICKET", "v1", System.getenv("STORY_POINTS_FIELD"));
        this.repository = new TicketRepository(crawler, dataMessage);
    }

    public void execute() throws CrawlerWorkException {
        logger.debug("Process JiraIssueCrawlMessage for endpoint {} issue {}", (Object)((JiraIssueCrawlMessage)this.message).getUrl(), (Object)((JiraIssueCrawlMessage)this.message).getId());
        CrawledDataWrappedResponse crawlResponse = this.responseFetcher.fetchEntity(Issue.class, JiraUrlHelper.issueURL(((JiraIssueCrawlMessage)this.message).getUrl()));
        this.save((CrawledDataWrappedResponse<Issue>)crawlResponse);
    }

    private boolean save(CrawledDataWrappedResponse<Issue> crawlResponse) throws CrawlerWorkException {
        UMWrappedEntity umData = this.umConvertible.convert(crawlResponse.getEntity());
        return this.repository.save(umData);
    }
}

