/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.um.models;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.jira.extractor.ChangelogExtractor;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TicketMapper {
    private static final Predicate<Map.Entry<String, String>> filterEmptyCustomFields = e -> ((String)e.getKey()).startsWith("customfield_") && e.getValue() != null && !((String)e.getValue()).equals("") && !((String)e.getValue()).equals("{}") && !((String)e.getValue()).equals("[]");
    private final String storyPointsField;

    public TicketMapper(String storyPointsField) {
        this.storyPointsField = storyPointsField;
    }

    public List<Ticket> extractTickets(Issue issue, ObjectMapper mapper) throws IOException {
        List<Issue> issues = ChangelogExtractor.extractIssues(issue, mapper);
        ArrayList<Ticket> acc = new ArrayList<Ticket>();
        for (int i = 0; i < issues.size(); ++i) {
            long version = (long)(issues.size() - i) - 1L;
            acc.add(this.map(issues.get(i), version));
        }
        return acc;
    }

    private Ticket map(Issue issue, long version) {
        Ticket ticket = new Ticket();
        ticket.setId(issue.getId());
        ticket.setVersion(version);
        ticket.setStartMs(issue.getLongDateValue("created"));
        ticket.setTitle(issue.getStringValue("summary"));
        ticket.setTicketType(issue.getStringValue("issuetype"));
        ticket.setStatus(issue.getStringValue("status"));
        ticket.setAssignee(issue.getStringValue("assignee"));
        ticket.setPriority(issue.getStringValue("priority"));
        ticket.setLabels(issue.getListValue("labels"));
        ticket.setVersionCreatedBy(issue.getStringValue("versionChangedBy"));
        ticket.setVersionCreatedByEmail(issue.getStringValue("versionChangedByEmail"));
        ticket.setComponents(issue.getListValue("components"));
        ticket.setAffectVersions(issue.getListValue("versions"));
        ticket.setStoryPoints(issue.getStringValue(this.storyPointsField));
        if (issue.getKey() != null && !issue.getKey().isEmpty()) {
            HashMap<String, String> relations = new HashMap<String, String>();
            relations.put("issueKey", issue.getKey());
            Ticket.Other other = new Ticket.Other(relations);
            ticket.setOther(other);
        }
        ticket.setAdditionalFields(TicketMapper.additionalFields(issue));
        ticket.setCustomFields(TicketMapper.customFields(issue));
        return ticket;
    }

    private static Map<String, Object> additionalFields(Issue issue) {
        HashMap<String, Object> additionalFields = new HashMap<String, Object>();
        additionalFields.put("key", issue.getKey());
        additionalFields.put("creator_display_name", issue.getStringValue("creator"));
        additionalFields.put("reporter_display_name", issue.getStringValue("reporter"));
        additionalFields.put("fix_versions", issue.getListValue("fixVersions"));
        additionalFields.put("project_key", issue.getStringValue("project"));
        additionalFields.put("time_spent", issue.getStringValue("timespent"));
        additionalFields.put("resolution", issue.getStringValue("resolution"));
        additionalFields.put("work_ratio", issue.getStringValue("workratio"));
        additionalFields.put("time_estimate", issue.getStringValue("timeestimate"));
        additionalFields.put("aggregate_time_original_estimate", issue.getStringValue("aggregatetimeorignalestimate"));
        additionalFields.put("time_original_estimate", issue.getStringValue("timeorignalestimate"));
        additionalFields.put("description", issue.getStringValue("description"));
        additionalFields.put("security", issue.getStringValue("security"));
        additionalFields.put("aggregate_time_estimate", issue.getStringValue("aggregatetimeestimate"));
        additionalFields.put("environment", issue.getStringValue("environment"));
        additionalFields.put("due_date", issue.getLongDateValue("duedate"));
        additionalFields.put("votes", issue.getStringValue("votes"));
        return additionalFields;
    }

    private static Map<String, Object> customFields(Issue issue) {
        return issue.getCleanedVersionRepresentation().entrySet().stream().filter(filterEmptyCustomFields).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

