/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.util;

import akka.NotUsed;
import akka.annotation.InternalApi;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.TLSProtocol;
import akka.stream.scaladsl.BidiFlow;
import akka.stream.scaladsl.BidiFlow$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.util.ByteString;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class LogByteStringTools$ {
    public static LogByteStringTools$ MODULE$;
    private final int MaxBytesPrinted;
    private final Attributes LogFailuresOnDebugAttributes;

    static {
        new LogByteStringTools$();
    }

    public int MaxBytesPrinted() {
        return this.MaxBytesPrinted;
    }

    private Attributes LogFailuresOnDebugAttributes() {
        return this.LogFailuresOnDebugAttributes;
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> logByteStringBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logByteString(new StringBuilder(5).append(name).append(" DOWN").toString(), maxBytes), this.logByteString(new StringBuilder(5).append(name).append(" UP  ").toString(), maxBytes));
    }

    public <A, B> BidiFlow<A, A, B, B, NotUsed> logToStringBidi(String name, int maxBytes, ClassTag<A> evidence$1, ClassTag<B> evidence$2) {
        return BidiFlow$.MODULE$.fromFlows(this.logToString(new StringBuilder(1).append(name).append(" ").append(LogByteStringTools$.limitedName$1(evidence$1)).toString(), maxBytes), this.logToString(new StringBuilder(1).append(name).append(" ").append(LogByteStringTools$.limitedName$1(evidence$2)).toString(), maxBytes));
    }

    public Flow<ByteString, ByteString, NotUsed> logByteString(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$7 = name;
        Function1<ByteString, String> & Serializable & scala.Serializable x$8 = (Function1<ByteString, String> & Serializable & scala.Serializable)x$1 -> MODULE$.printByteString((ByteString)x$1, maxBytes);
        LoggingAdapter x$9 = qual$1.log$default$3(x$7, x$8);
        return ((Flow)qual$1.log(x$7, x$8, x$9)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logByteStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public int logByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> Flow<A, A, NotUsed> logToString(String name, int maxBytes) {
        Flow qual$2 = Flow$.MODULE$.apply();
        String x$10 = name;
        Function1<Object, String> & Serializable & scala.Serializable x$11 = (Function1<Object, String> & Serializable & scala.Serializable)x$2 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$2.toString())).take(maxBytes);
        LoggingAdapter x$12 = qual$2.log$default$3(x$10, x$11);
        return ((Flow)qual$2.log(x$10, x$11, x$12)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public <A, B> int logToStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> int logToString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTLSBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logTlsOutbound(new StringBuilder(8).append(name).append(" ToNet  ").toString(), maxBytes), this.logTlsInbound(new StringBuilder(8).append(name).append(" FromNet").toString(), maxBytes));
    }

    public int logTLSBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, NotUsed> logTlsOutbound(String name, int maxBytes) {
        Flow qual$3 = Flow$.MODULE$.apply();
        String x$13 = name;
        Function1<TLSProtocol.SslTlsOutbound, Object> & Serializable & scala.Serializable x$14 = (Function1<TLSProtocol.SslTlsOutbound, Object> & Serializable & scala.Serializable)x0$1 -> {
            String string;
            TLSProtocol.SslTlsOutbound sslTlsOutbound = x0$1;
            if (sslTlsOutbound instanceof TLSProtocol.SendBytes) {
                TLSProtocol.SendBytes sendBytes = (TLSProtocol.SendBytes)sslTlsOutbound;
                ByteString bytes = sendBytes.bytes();
                string = new StringBuilder(10).append("SendBytes ").append(MODULE$.printByteString(bytes, maxBytes)).toString();
            } else if (sslTlsOutbound instanceof TLSProtocol.NegotiateNewSession) {
                TLSProtocol.NegotiateNewSession negotiateNewSession = (TLSProtocol.NegotiateNewSession)sslTlsOutbound;
                string = negotiateNewSession.toString();
            } else {
                throw new MatchError(sslTlsOutbound);
            }
            return string;
        };
        LoggingAdapter x$15 = qual$3.log$default$3(x$13, x$14);
        return ((Flow)qual$3.log(x$13, x$14, x$15)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logTlsOutbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTlsInbound(String name, int maxBytes) {
        Flow qual$4 = Flow$.MODULE$.apply();
        String x$16 = name;
        Function1<TLSProtocol.SslTlsInbound, Object> & Serializable & scala.Serializable x$17 = (Function1<TLSProtocol.SslTlsInbound, Object> & Serializable & scala.Serializable)x0$2 -> {
            Object object;
            TLSProtocol.SslTlsInbound sslTlsInbound = x0$2;
            if (sslTlsInbound instanceof TLSProtocol.SessionTruncated) {
                TLSProtocol.SessionTruncated sessionTruncated = (TLSProtocol.SessionTruncated)sslTlsInbound;
                object = sessionTruncated;
            } else if (sslTlsInbound instanceof TLSProtocol.SessionBytes) {
                TLSProtocol.SessionBytes sessionBytes = (TLSProtocol.SessionBytes)sslTlsInbound;
                ByteString bytes = sessionBytes.bytes();
                object = new StringBuilder(13).append("SessionBytes ").append(MODULE$.printByteString(bytes, maxBytes)).toString();
            } else {
                throw new MatchError(sslTlsInbound);
            }
            return object;
        };
        LoggingAdapter x$18 = qual$4.log$default$3(x$16, x$17);
        return ((Flow)qual$4.log(x$16, x$17, x$18)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logTlsInbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public String printByteString(ByteString bytes, int maxBytes) {
        String indent = " ";
        return LogByteStringTools$.formatBytes$1(bytes, maxBytes, indent).mkString("");
    }

    public int printByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, Object> logTLSBidiBySetting(String tag, Option<Object> maxBytesSetting) {
        return (BidiFlow)maxBytesSetting.map((Function1<Object, BidiFlow> & Serializable & scala.Serializable)x$3 -> LogByteStringTools$.MODULE$.logTLSBidi(tag, BoxesRunTime.unboxToInt(x$3))).getOrElse((Function0<BidiFlow> & Serializable & scala.Serializable)() -> BidiFlow$.MODULE$.identity());
    }

    private static final String limitedName$1(ClassTag tag) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(Logging$.MODULE$.simpleName(tag.runtimeClass()))).take(20))).mkString();
    }

    private static final String asHex$1(byte b) {
        return Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToByte(b)), "%02X");
    }

    private static final char asASCII$1(byte b) {
        return b >= 32 && b < 127 ? (char)b : (char)'.';
    }

    private static final String formatLine$1(ByteString bs, String indent$1) {
        String hex = ((TraversableOnce)bs.map((Function1<Object, String> & Serializable & scala.Serializable)b -> LogByteStringTools$.asHex$1(BoxesRunTime.unboxToByte(b)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
        String ascii = ((TraversableOnce)bs.map((Function1<Object, Object> & Serializable & scala.Serializable)b -> BoxesRunTime.boxToCharacter(LogByteStringTools$.asASCII$1(BoxesRunTime.unboxToByte(b))), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
        String arg$macro$2 = indent$1;
        String arg$macro$3 = hex;
        String arg$macro$4 = ascii;
        return new StringOps("%s  %-48s | %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$2, arg$macro$3, arg$macro$4}));
    }

    private static final String formatBytes$2(ByteString bs2, String indent$1) {
        return bs2.grouped(16).map((Function1<ByteString, String> & Serializable & scala.Serializable)bs -> LogByteStringTools$.formatLine$1(bs, indent$1)).mkString("\n");
    }

    private static final Iterator formatBytes$1(ByteString bs, int maxBytes$3, String indent$1) {
        String prefix = new StringBuilder(18).append(indent$1).append("ByteString(").append(bs.size()).append(" bytes)").toString();
        return bs.size() <= maxBytes$3 * 2 ? package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append(prefix).append("\n").toString(), LogByteStringTools$.formatBytes$2(bs, indent$1)})) : package$.MODULE$.Iterator().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append(prefix).append(" first + last ").append(maxBytes$3).append(":\n").toString(), LogByteStringTools$.formatBytes$2(bs.take(maxBytes$3), indent$1), new StringBuilder(46).append("\n").append(indent$1).append("                    ... [").append(bs.size() - maxBytes$3 * 2).append(" bytes omitted] ...\n").toString(), LogByteStringTools$.formatBytes$2(bs.takeRight(maxBytes$3), indent$1)}));
    }

    private LogByteStringTools$() {
        MODULE$ = this;
        this.MaxBytesPrinted = 80;
        int x$4 = Logging$.MODULE$.DebugLevel();
        int x$5 = Attributes$.MODULE$.logLevels$default$1();
        int x$6 = Attributes$.MODULE$.logLevels$default$2();
        this.LogFailuresOnDebugAttributes = Attributes$.MODULE$.logLevels(x$5, x$6, x$4);
    }
}

