/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.xebialabs.agatha.crawlers.jira.extractor.ValueHolder;
import com.xebialabs.agatha.crawlers.jira.models.Changelog;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.joda.time.DateTime;

public class ChangelogExtractor {
    private static final String ISO_DATE_PATTERN = "^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d\\d\\d)?(?:Z|[+-]\\d\\d:?\\d\\d)$";
    private static final String SIMPLE_DATE_PATTERN = "(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])))";
    private static final String CREATED_DATE = "created";
    private static final String VERSION_CHANGED_BY = "versionChangedBy";
    private static final String VERSION_CHANGED_BY_EMAIL = "versionChangedByEmail";
    private static final Map<String, String> fieldsWithKey = new HashMap<String, String>(){
        {
            this.put("project", "key");
        }
    };
    private static final List<String> FIELDS_WITH_MEANINGFUL_VALUE = Arrays.asList("votes", "displayName", "name", "description", "key", "value", "id");
    private static final String CUSTOM_FIELD = "customfield_";

    private ChangelogExtractor() {
    }

    private static String extractValue(JsonNode objectNode, String name) {
        if (objectNode == null) {
            return "";
        }
        if (objectNode instanceof TextNode) {
            if (name.startsWith(CUSTOM_FIELD)) {
                return ChangelogExtractor.getString(objectNode.asText());
            }
            return objectNode.asText();
        }
        if (fieldsWithKey.containsKey(name)) {
            return Optional.ofNullable(objectNode.findPath(fieldsWithKey.get(name))).filter(n -> !n.isMissingNode()).map(JsonNode::asText).orElse("");
        }
        Stream<String> meaningfulValues = FIELDS_WITH_MEANINGFUL_VALUE.stream().flatMap(v -> {
            JsonNode node = objectNode.findPath(v);
            if (node.isMissingNode() || node.asText().equals("")) {
                return Stream.empty();
            }
            return Stream.of(node.asText());
        });
        if (name.startsWith("customfield")) {
            return meaningfulValues.collect(Collectors.joining(","));
        }
        return meaningfulValues.findFirst().orElse("");
    }

    private static String getString(String input) {
        Pattern isoPattern = Pattern.compile(ISO_DATE_PATTERN);
        Pattern simpleDatePattern = Pattern.compile(SIMPLE_DATE_PATTERN);
        Matcher matcher = isoPattern.matcher(input);
        Matcher simpleMatcher = simpleDatePattern.matcher(input);
        return matcher.matches() || simpleMatcher.matches() ? String.valueOf(new DateTime((Object)input).toDate().getTime()) : input;
    }

    private static Map<String, ValueHolder> getVersionRepresentations(JsonNode jsonNode) {
        JsonNode representations = jsonNode.findPath("versionedRepresentations").findPath("properties");
        Iterable versionedRepresentations = () -> ((JsonNode)representations).fieldNames();
        HashMap<String, ValueHolder> acc = new HashMap<String, ValueHolder>();
        for (String fieldName : versionedRepresentations) {
            JsonNode node = representations.get(fieldName);
            ArrayList<ValueHolder> versions = new ArrayList<ValueHolder>();
            for (int i = 1; i < node.size() + 1; ++i) {
                ValueHolder v = ChangelogExtractor.getValues(node, String.valueOf(i), fieldName);
                versions.add(v);
            }
            if (versions.isEmpty()) continue;
            ValueHolder last = (ValueHolder)versions.get(versions.size() - 1);
            acc.put(fieldName, last);
        }
        return acc;
    }

    public static List<Issue> extractIssues(Issue issue, ObjectMapper mapper) throws IOException {
        List<Changelog.History> histories = issue.getChangelog().getHistories();
        if (histories.isEmpty()) {
            return Collections.singletonList(issue);
        }
        JsonNode jsonNode = (JsonNode)mapper.convertValue((Object)issue, JsonNode.class);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Map<String, ValueHolder> lastVersionedReps = ChangelogExtractor.getVersionRepresentations(jsonNode);
        ValueHolder firstIssueCreatedDate = lastVersionedReps.get(CREATED_DATE);
        lastVersionedReps.remove("updated");
        Issue next = (Issue)((Object)mapper.readValue(mapper.writeValueAsString((Object)issue), Issue.class));
        next.setCleanedVersionRepresentation(lastVersionedReps);
        Changelog.History head = histories.get(0);
        next.getCleanedVersionRepresentation().put(CREATED_DATE, new ValueHolder(head.getCreated()));
        next.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY, new ValueHolder(head.getAuthor().getDisplayName()));
        next.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY_EMAIL, new ValueHolder(head.getAuthor().getEmailAddress()));
        issues.add(next);
        for (int idx = 0; idx < histories.size(); ++idx) {
            Issue oldIssue = ChangelogExtractor.rollBackIssue(histories, next, idx, mapper, lastVersionedReps);
            issues.add(oldIssue);
            next = oldIssue;
        }
        if (!issues.isEmpty()) {
            Issue firstVersion = (Issue)((Object)issues.get(issues.size() - 1));
            firstVersion.getCleanedVersionRepresentation().put(CREATED_DATE, firstIssueCreatedDate);
        }
        return issues;
    }

    private static Issue rollBackIssue(List<Changelog.History> histories, Issue next, int idx, ObjectMapper mapper, Map<String, ValueHolder> lastVersionedReps) throws IOException {
        Changelog.History history = histories.get(idx);
        Issue deepCopy = (Issue)((Object)mapper.readValue(mapper.writeValueAsString((Object)next), Issue.class));
        history.getItems().forEach(elm -> {
            String key = Optional.ofNullable(elm.getFieldId()).orElse(elm.getField());
            ValueHolder valueHolder = (ValueHolder)lastVersionedReps.get(key);
            if (valueHolder != null && valueHolder.getValue() instanceof List && elm.getFromString() != null) {
                String[] split = elm.getFromString().split("/,");
                deepCopy.getCleanedVersionRepresentation().put(key, new ValueHolder(Arrays.asList(split)));
            } else if (!key.startsWith(CUSTOM_FIELD)) {
                deepCopy.getCleanedVersionRepresentation().put(key, new ValueHolder(elm.getFromString()));
            }
        });
        int nextIdx = idx + 1;
        if (nextIdx != histories.size()) {
            Changelog.History prevHistory = histories.get(nextIdx);
            deepCopy.getCleanedVersionRepresentation().put(CREATED_DATE, new ValueHolder(prevHistory.getCreated()));
            deepCopy.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY, new ValueHolder(prevHistory.getAuthor().getDisplayName()));
            deepCopy.getCleanedVersionRepresentation().put(VERSION_CHANGED_BY_EMAIL, new ValueHolder(prevHistory.getAuthor().getEmailAddress()));
        }
        return deepCopy;
    }

    private static ValueHolder getValues(JsonNode node, String number, String name) {
        JsonNode root = node.findPath(number);
        Function<ArrayNode, List<String>> map = v -> {
            Iterable<JsonNode> iter = new ArrayNodeIterator((ArrayNode)v).iterable();
            return StreamSupport.stream(iter.spliterator(), false).map(val -> ChangelogExtractor.extractValue(val, name)).filter(f -> !f.trim().isEmpty()).collect(Collectors.toList());
        };
        Optional<List<String>> values = ChangelogExtractor.tryExtractFromArrayNode(root, map);
        return values.map(ValueHolder::new).orElseGet(() -> new ValueHolder(ChangelogExtractor.extractValue(root, name)));
    }

    private static Optional<List<String>> tryExtractFromArrayNode(Object value, Function<ArrayNode, List<String>> fn) {
        if (value instanceof ArrayNode) {
            return Optional.ofNullable(fn.apply((ArrayNode)value));
        }
        return Optional.empty();
    }

    private static class ArrayNodeIterator
    implements Iterator<JsonNode> {
        private ArrayNode source;
        int counter = 0;

        ArrayNodeIterator(ArrayNode source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.counter <= this.source.size();
        }

        @Override
        public JsonNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JsonNode jsonNode = this.source.get(this.counter);
            ++this.counter;
            return jsonNode;
        }

        Iterable<JsonNode> iterable() {
            return () -> this;
        }
    }
}

