/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xebialabs.agatha.crawlers.AbstractCrawler;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.KeyValueCoordinatesGenerator;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class BaseRepository<C extends AbstractCrawler, E>
implements KeyValueRepository<E> {
    protected final C crawler;
    protected final BaseCrawlerMessage dataMessage;

    public BaseRepository(C crawler, BaseCrawlerMessage dataMessage) {
        this.crawler = crawler;
        this.dataMessage = dataMessage;
    }

    protected boolean save(UMWrappedEntity<E> umData, KeyValueCoordinatesGenerator generator) throws CrawlerWorkException {
        return this.crawler.sendCrawledDataAndDecideToContinue(this.dataMessage, (Object)umData.getWrappedData(), umData.getDataSourceType(), generator.artifactId(), generator.version());
    }

    protected boolean saveWithStream(UMWrappedEntity<E> umdata, Reader streamData, KeyValueCoordinatesGenerator generator) throws CrawlerWorkException {
        return this.crawler.sendCrawledDataStreamAndDecideToContinue(this.dataMessage, (Object)umdata.getWrappedData(), streamData, umdata.getDataSourceType(), generator.artifactId(), generator.version());
    }

    public static class FieldsKeyValueCoordinatesGenerator<C extends AbstractCrawler, E>
    implements KeyValueCoordinatesGenerator {
        private final UMWrappedEntity<E> umData;
        private final C crawler;
        private static final String TYPE = "fields";
        private static final String HASH_ALGORITHM = "SHA-1";
        private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

        public FieldsKeyValueCoordinatesGenerator(UMWrappedEntity<E> umData, C crawler) {
            this.umData = umData;
            this.crawler = crawler;
        }

        @Override
        public String artifactId() {
            return TYPE;
        }

        @Override
        public String version() throws CrawlerWorkException {
            try {
                String json = this.crawler.getMapper().writeValueAsString(this.umData.getData());
                MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
                return new BigInteger(1, md.digest(json.getBytes(UTF8_CHARSET))).toString(16);
            }
            catch (JsonProcessingException | NoSuchAlgorithmException e) {
                throw new CrawlerWorkException(e);
            }
        }
    }

    public static class DefaultKeyValueCoordinatesGenerator<E>
    implements KeyValueCoordinatesGenerator {
        private final UMWrappedEntity<E> umData;

        public DefaultKeyValueCoordinatesGenerator(UMWrappedEntity<E> umData) {
            this.umData = umData;
        }

        @Override
        public String artifactId() {
            return this.umData.getId();
        }

        @Override
        public String version() {
            return this.umData.getVersion();
        }
    }
}

