/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.jira.services.crawl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.jira.JiraCrawler;
import com.xebialabs.agatha.crawlers.jira.components.helpers.JiraUrlHelper;
import com.xebialabs.agatha.crawlers.jira.messages.JiraIssueCrawlMessage;
import com.xebialabs.agatha.crawlers.jira.models.Issue;
import com.xebialabs.agatha.crawlers.jira.repository.TicketRepository;
import com.xebialabs.agatha.crawlers.jira.services.crawl.JiraBaseCrawl;
import com.xebialabs.agatha.crawlers.jira.um.converters.IssueListConverter;
import com.xebialabs.agatha.crawlers.jira.um.models.Ticket;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIssueCrawl
extends JiraBaseCrawl<JiraIssueCrawlMessage> {
    private static final Logger logger = LoggerFactory.getLogger(JiraIssueCrawl.class);
    private static final TypeReference<Map<String, Object>> mapTypeRef = new TypeReference<Map<String, Object>>(){};
    private final UMConverter<List<Ticket>, Issue> umConvertible;
    private final KeyValueRepository<List<Ticket>> repository;

    public JiraIssueCrawl(JiraCrawler crawler, JiraIssueCrawlMessage message, BaseCrawlerMessage dataMessage, ObjectMapper mapper) {
        super(crawler, message, dataMessage);
        this.umConvertible = new IssueListConverter(message.getPluginId(), "v1", "TICKET", "v1", System.getenv("STORY_POINTS_FIELD"), mapper);
        this.repository = new TicketRepository(crawler, dataMessage);
    }

    public void execute() throws CrawlerWorkException {
        logger.debug("Process JiraIssueCrawlMessage for endpoint {} issue {}", (Object)((JiraIssueCrawlMessage)this.message).getUrl(), (Object)((JiraIssueCrawlMessage)this.message).getId());
        CrawledDataWrappedResponse crawlResponse = this.responseFetcher.fetchEntity(Issue.class, JiraUrlHelper.issueURL(((JiraIssueCrawlMessage)this.message).getUrl()));
        this.save((CrawledDataWrappedResponse<Issue>)crawlResponse);
    }

    private boolean save(CrawledDataWrappedResponse<Issue> crawlResponse) throws CrawlerWorkException {
        UMWrappedEntity umData = this.umConvertible.convert(crawlResponse.getEntity());
        try {
            Map raw = (Map)this.crawler.getMapper().readValue(crawlResponse.getContent(), mapTypeRef);
            ((Ticket)((List)umData.getData()).get(0)).getOther().setRaw(raw);
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return this.repository.save(umData);
    }
}

