/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.Done;
import akka.Done$;
import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.dispatch.ExecutionContexts;
import akka.io.Inet;
import akka.io.Tcp;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.BindFailedException;
import akka.stream.IOSettings;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.SourceShape;
import akka.stream.impl.fusing.GraphStages$;
import akka.stream.impl.io.ConnectionSourceStage$;
import akka.stream.impl.io.IncomingConnectionStage;
import akka.stream.impl.io.TcpIdleTimeout$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Tcp;
import akka.stream.scaladsl.Tcp$ServerBinding$;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Traversable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0001\u0019Q!!F\"p]:,7\r^5p]N{WO]2f'R\fw-\u001a\u0006\u0003\u0007\u0011\t!![8\u000b\u0005\u00151\u0011\u0001B5na2T!a\u0002\u0005\u0002\rM$(/Z1n\u0015\u0005I\u0011\u0001B1lW\u0006\u001c\"\u0001A\u0006\u0011\t1y\u0011cH\u0007\u0002\u001b)\u0011aBB\u0001\u0006gR\fw-Z\u0005\u0003!5\u0011qd\u0012:ba\"\u001cF/Y4f/&$\b.T1uKJL\u0017\r\\5{K\u00124\u0016\r\\;f!\r\u00112#F\u0007\u0002\r%\u0011AC\u0002\u0002\f'>,(oY3TQ\u0006\u0004X\r\u0005\u0002\u001799\u0011qCG\u0007\u00021)\u0011\u0011DB\u0001\tg\u000e\fG.\u00193tY&\u00111\u0004G\u0001\u0004)\u000e\u0004\u0018BA\u000f\u001f\u0005IIenY8nS:<7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005mA\u0002c\u0001\u0011&O5\t\u0011E\u0003\u0002#G\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0011\u0003\r\u0019+H/\u001e:f!\t1\u0002&\u0003\u0002*=\ti1+\u001a:wKJ\u0014\u0015N\u001c3j]\u001eD\u0001b\u000b\u0001\u0003\u0006\u0004%\t!L\u0001\u000bi\u000e\u0004X*\u00198bO\u0016\u00148\u0001A\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007C\u0001\u0006C\u000e$xN]\u0005\u0003gA\u0012\u0001\"Q2u_J\u0014VM\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005]\u0005YAo\u00199NC:\fw-\u001a:!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001C3oIB|\u0017N\u001c;\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u00079,GOC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$!E%oKR\u001cvnY6fi\u0006#GM]3tg\"A!\t\u0001B\u0001B\u0003%\u0011(A\u0005f]\u0012\u0004x.\u001b8uA!AA\t\u0001BC\u0002\u0013\u0005Q)A\u0004cC\u000e\\Gn\\4\u0016\u0003\u0019\u0003\"a\u0012%\u000e\u0003\rJ!!S\u0012\u0003\u0007%sG\u000f\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003G\u0003!\u0011\u0017mY6m_\u001e\u0004\u0003\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0001(\u0002\u000f=\u0004H/[8ogV\tq\nE\u0002Q+^k\u0011!\u0015\u0006\u0003%N\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005Q\u001b\u0013AC2pY2,7\r^5p]&\u0011a+\u0015\u0002\f)J\fg/\u001a:tC\ndW\r\u0005\u0002YG:\u0011\u0011\f\u0019\b\u00035~s!a\u00170\u000e\u0003qS!!\u0018\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0002\t\u0013\t\t'-\u0001\u0003J]\u0016$(BA\u0002\t\u0013\t!WM\u0001\u0007T_\u000e\\W\r^(qi&|gN\u0003\u0002bE\"Aq\r\u0001B\u0001B\u0003%q*\u0001\u0005paRLwN\\:!\u0011!I\u0007A!b\u0001\n\u0003Q\u0017!\u00035bY\u001a\u001cEn\\:f+\u0005Y\u0007CA$m\u0013\ti7EA\u0004C_>dW-\u00198\t\u0011=\u0004!\u0011!Q\u0001\n-\f!\u0002[1mM\u000ecwn]3!\u0011!\t\bA!b\u0001\n\u0003\u0011\u0018aC5eY\u0016$\u0016.\\3pkR,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m\u0006\n\u0001\u0002Z;sCRLwN\\\u0005\u0003qV\u0014\u0001\u0002R;sCRLwN\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005g\u0006a\u0011\u000e\u001a7f)&lWm\\;uA!AA\u0010\u0001BC\u0002\u0013\u0005Q0A\ncS:$7\u000b[;uI><h\u000eV5nK>,H/F\u0001\u007f!\t!x0C\u0002\u0002\u0002U\u0014aBR5oSR,G)\u001e:bi&|g\u000eC\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005}\u0006!\"-\u001b8e'\",H\u000fZ8x]RKW.Z8vi\u0002B!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0003)IwnU3ui&twm]\u000b\u0003\u0003\u001b\u00012AEA\b\u0013\r\t\tB\u0002\u0002\u000b\u0013>\u001bV\r\u001e;j]\u001e\u001c\bBCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u000e\u0005Y\u0011n\\*fiRLgnZ:!\u0011\u001d\tI\u0002\u0001C\u0001\u00037\ta\u0001P5oSRtDCEA\u000f\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\u00012!a\b\u0001\u001b\u0005\u0011\u0001BB\u0016\u0002\u0018\u0001\u0007a\u0006\u0003\u00048\u0003/\u0001\r!\u000f\u0005\u0007\t\u0006]\u0001\u0019\u0001$\t\r5\u000b9\u00021\u0001P\u0011\u0019I\u0017q\u0003a\u0001W\"1\u0011/a\u0006A\u0002MDa\u0001`A\f\u0001\u0004q\b\u0002CA\u0005\u0003/\u0001\r!!\u0004\t\u0013\u0005M\u0002A1A\u0005\u0002\u0005U\u0012aA8viV\u0011\u0011q\u0007\t\u0005%\u0005eR#C\u0002\u0002<\u0019\u0011aaT;uY\u0016$\b\u0002CA \u0001\u0001\u0006I!a\u000e\u0002\t=,H\u000f\t\u0005\b\u0003\u0007\u0002A\u0011IA#\u0003EIg.\u001b;jC2\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003\u000f\u00022AEA%\u0013\r\tYE\u0002\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\b\"CA(\u0001\t\u0007I\u0011AA)\u0003\u0015\u0019\b.\u00199f+\u0005\t\u0002bBA+\u0001\u0001\u0006I!E\u0001\u0007g\"\f\u0007/\u001a\u0011\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005y2M]3bi\u0016dunZ5d\u0003:$W*\u0019;fe&\fG.\u001b>fIZ\u000bG.^3\u0015\t\u0005u\u0013q\u000f\t\b\u000f\u0006}\u00131MA5\u0013\r\t\tg\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00071\t)'C\u0002\u0002h5\u0011qb\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\t\u0005A\u0015\nY\u0007E\u0002\u0002n!r1!a\u001c\u001b\u001d\u0011\t\t(!\u001e\u000f\u0007i\u000b\u0019(\u0003\u0002\b\u0011%\u0011\u0011D\u0002\u0005\t\u0003s\n9\u00061\u0001\u0002H\u0005\u0019\u0012N\u001c5fe&$X\rZ!uiJL'-\u001e;fg\"\u001a\u0001!! \u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!\t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\u000b\tIA\u0006J]R,'O\\1m\u0003BLw\u0001CAF\u0005!\u0005a!!$\u0002+\r{gN\\3di&|gnU8ve\u000e,7\u000b^1hKB!\u0011qDAH\r\u001d\t!\u0001#\u0001\u0007\u0003#\u001bB!a$\u0002\u0014B\u0019q)!&\n\u0007\u0005]5E\u0001\u0004B]f\u0014VM\u001a\u0005\t\u00033\ty\t\"\u0001\u0002\u001cR\u0011\u0011Q\u0012\u0005\u000b\u0003?\u000byI1A\u0005\u0002\u0005\u0005\u0016!\u0003\"j]\u0012$\u0016.\\3s+\t\t\u0019\u000b\u0005\u0003\u0002&\u0006-VBAAT\u0015\r\tI+P\u0001\u0005Y\u0006tw-\u0003\u0003\u0002.\u0006\u001d&AB*ue&tw\rC\u0005\u00022\u0006=\u0005\u0015!\u0003\u0002$\u0006Q!)\u001b8e)&lWM\u001d\u0011\t\u0015\u0005U\u0016q\u0012b\u0001\n\u0003\t\t+A\tCS:$7\u000b[;uI><h\u000eV5nKJD\u0011\"!/\u0002\u0010\u0002\u0006I!a)\u0002%\tKg\u000eZ*ikR$wn\u001e8US6,'\u000f\t")
@InternalApi
public class ConnectionSourceStage
extends GraphStageWithMaterializedValue<SourceShape<Tcp.IncomingConnection>, Future<Tcp.ServerBinding>> {
    private final ActorRef tcpManager;
    private final InetSocketAddress endpoint;
    private final int backlog;
    private final Traversable<Inet.SocketOption> options;
    private final boolean halfClose;
    private final Duration idleTimeout;
    private final FiniteDuration bindShutdownTimeout;
    private final IOSettings ioSettings;
    private final Outlet<Tcp.IncomingConnection> out;
    private final SourceShape<Tcp.IncomingConnection> shape;

    public static String BindShutdownTimer() {
        return ConnectionSourceStage$.MODULE$.BindShutdownTimer();
    }

    public static String BindTimer() {
        return ConnectionSourceStage$.MODULE$.BindTimer();
    }

    public ActorRef tcpManager() {
        return this.tcpManager;
    }

    public InetSocketAddress endpoint() {
        return this.endpoint;
    }

    public int backlog() {
        return this.backlog;
    }

    public Traversable<Inet.SocketOption> options() {
        return this.options;
    }

    public boolean halfClose() {
        return this.halfClose;
    }

    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public FiniteDuration bindShutdownTimeout() {
        return this.bindShutdownTimeout;
    }

    public IOSettings ioSettings() {
        return this.ioSettings;
    }

    public Outlet<Tcp.IncomingConnection> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("ConnectionSource");
    }

    @Override
    public SourceShape<Tcp.IncomingConnection> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.ServerBinding>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise bindingPromise = Promise$.MODULE$.apply();
        TimerGraphStageLogic logic = new TimerGraphStageLogic(this, bindingPromise){
            private final AtomicLong connectionFlowsAwaitingInitialization;
            private ActorRef listener;
            private final Promise<BoxedUnit> unbindPromise;
            private boolean unbindStarted;
            private final /* synthetic */ ConnectionSourceStage $outer;
            private final Promise bindingPromise$1;

            public ActorRef self() {
                return this.stageActor().ref();
            }

            public AtomicLong connectionFlowsAwaitingInitialization() {
                return this.connectionFlowsAwaitingInitialization;
            }

            public ActorRef listener() {
                return this.listener;
            }

            public void listener_$eq(ActorRef x$1) {
                this.listener = x$1;
            }

            public Promise<BoxedUnit> unbindPromise() {
                return this.unbindPromise;
            }

            public boolean unbindStarted() {
                return this.unbindStarted;
            }

            public void unbindStarted_$eq(boolean x$1) {
                this.unbindStarted = x$1;
            }

            public void preStart() {
                this.getStageActor((Function1<Tuple2<ActorRef, Object>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)evt -> {
                    $anon$2.$anonfun$preStart$1(this, evt);
                    return BoxedUnit.UNIT;
                });
                package$.MODULE$.actorRef2Scala(this.$outer.tcpManager()).$bang((Object)new Tcp.Bind(this.self(), this.$outer.endpoint(), this.$outer.backlog(), this.$outer.options(), true), this.self());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void receive(Tuple2<ActorRef, Object> evt) {
                ActorRef sender = (ActorRef)evt._1();
                Object msg = evt._2();
                Object object = msg;
                if (object instanceof Tcp.Bound) {
                    Tcp.Bound bound = (Tcp.Bound)object;
                    InetSocketAddress localAddress = bound.localAddress();
                    this.listener_$eq(sender);
                    this.stageActor().watch(this.listener());
                    if (this.isAvailable(this.$outer.out())) {
                        package$.MODULE$.actorRef2Scala(this.listener()).$bang((Object)new Tcp.ResumeAccepting(1), this.self());
                    }
                    ActorRef thisStage = this.self();
                    this.bindingPromise$1.success((Object)Tcp$ServerBinding$.MODULE$.apply(localAddress, (Function0<Future<BoxedUnit>>)(Function0 & Serializable & scala.Serializable)() -> {
                        thisStage.tell((Object)Tcp.Unbind$.MODULE$, thisStage);
                        return this.unbindPromise().future();
                    }, (Future<Done>)this.unbindPromise().future().map((Function1 & Serializable & scala.Serializable)x$1 -> Done$.MODULE$, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (object instanceof Tcp.CommandFailed) {
                    Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)object;
                    BindFailedException ex = new BindFailedException(null, commandFailed){
                        private final Tcp.CommandFailed x4$1;

                        public String getMessage() {
                            return new StringBuilder(11).append("Bind failed").append(this.x4$1.causedByString()).toString();
                        }
                        {
                            this.x4$1 = x4$1;
                        }
                    };
                    commandFailed.cause().foreach((Function1 & Serializable & scala.Serializable)x$1 -> ex.initCause((Throwable)x$1));
                    this.bindingPromise$1.failure((Throwable)ex);
                    this.unbindPromise().tryFailure((Throwable)ex);
                    this.failStage(ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (object instanceof Tcp.Connected) {
                    Tcp.Connected connected = (Tcp.Connected)object;
                    this.push(this.$outer.out(), this.connectionFor(connected, sender));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else if (Tcp.Unbind$.MODULE$.equals(object)) {
                    BoxedUnit boxedUnit;
                    if (!this.isClosed(this.$outer.out()) && this.listener() != null) {
                        this.akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                } else if (Tcp.Unbound$.MODULE$.equals(object)) {
                    this.unbindCompleted();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    BoxedUnit boxedUnit;
                    ActorRef ref;
                    if (!(object instanceof Terminated)) throw new MatchError(object);
                    Terminated terminated = (Terminated)object;
                    ActorRef actorRef2 = ref = terminated.actor();
                    ActorRef actorRef3 = this.listener();
                    if (actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null) throw new MatchError(object);
                    if (this.unbindStarted()) {
                        this.unbindCompleted();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        IllegalStateException ex = new IllegalStateException(new StringBuilder(65).append("IO Listener actor terminated unexpectedly for remote endpoint [").append(this.$outer.endpoint().getHostString()).append(":").append(this.$outer.endpoint().getPort()).append("]").toString());
                        this.unbindPromise().tryFailure((Throwable)ex);
                        this.failStage(ex);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
            }

            private Tcp.IncomingConnection connectionFor(Tcp.Connected connected, ActorRef connection) {
                Flow<ByteString, ByteString, NotUsed> flow;
                this.connectionFlowsAwaitingInitialization().incrementAndGet();
                Flow<ByteString, ByteString, NotUsed> tcpFlow = ((Flow)Flow$.MODULE$.fromGraph(new IncomingConnectionStage(connection, connected.remoteAddress(), this.$outer.halfClose(), this.$outer.ioSettings())).via(GraphStages$.MODULE$.detacher())).mapMaterializedValue((Function1 & Serializable & scala.Serializable)m -> {
                    this.connectionFlowsAwaitingInitialization().decrementAndGet();
                    return m;
                });
                Duration duration = this.$outer.idleTimeout();
                if (duration instanceof FiniteDuration) {
                    FiniteDuration finiteDuration = (FiniteDuration)duration;
                    flow = tcpFlow.join(TcpIdleTimeout$.MODULE$.apply(finiteDuration, (Option<InetSocketAddress>)new Some((Object)connected.remoteAddress())));
                } else {
                    flow = tcpFlow;
                }
                Flow<ByteString, ByteString, NotUsed> handler = flow;
                return new Tcp.IncomingConnection(connected.localAddress(), connected.remoteAddress(), handler);
            }

            public void akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind() {
                block0: {
                    if (this.listener() == null || this.unbindStarted()) break block0;
                    this.unbindStarted_$eq(true);
                    this.setKeepGoing(true);
                    package$.MODULE$.actorRef2Scala(this.listener()).$bang((Object)Tcp.Unbind$.MODULE$, this.self());
                }
            }

            private void unbindCompleted() {
                this.stageActor().unwatch(this.listener());
                this.unbindPromise().trySuccess((Object)BoxedUnit.UNIT);
                if (this.connectionFlowsAwaitingInitialization().get() == 0L) {
                    this.completeStage();
                } else {
                    this.scheduleOnce((Object)ConnectionSourceStage$.MODULE$.BindShutdownTimer(), this.$outer.bindShutdownTimeout());
                }
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                String string = ConnectionSourceStage$.MODULE$.BindShutdownTimer();
                Object object2 = object;
                if (string != null ? !string.equals(object2) : object2 != null) {
                    throw new MatchError(object);
                }
                this.completeStage();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            public void postStop() {
                this.unbindPromise().trySuccess((Object)BoxedUnit.UNIT);
                this.bindingPromise$1.tryFailure((Throwable)new NoSuchElementException("Binding was unbound before it was completely finished"));
            }

            public static final /* synthetic */ void $anonfun$preStart$1($anon$2 $this, Tuple2 evt) {
                $this.receive((Tuple2<ActorRef, Object>)evt);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bindingPromise$1 = bindingPromise$1;
                super($outer.shape());
                this.connectionFlowsAwaitingInitialization = new AtomicLong();
                this.unbindPromise = Promise$.MODULE$.apply();
                this.unbindStarted = false;
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public void onPull() {
                        block0: {
                            if (this.$outer.listener() == null) break block0;
                            package$.MODULE$.actorRef2Scala(this.$outer.listener()).$bang((Object)new Tcp.ResumeAccepting(1), this.$outer.self());
                        }
                    }

                    public void onDownstreamFinish() {
                        this.$outer.akka$stream$impl$io$ConnectionSourceStage$$anon$$tryUnbind();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        OutHandler.$init$(this);
                    }
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$preStart$1$adapted(akka.stream.impl.io.ConnectionSourceStage$$anon$2 scala.Tuple2 ), $anonfun$receive$1(akka.stream.impl.io.ConnectionSourceStage$$anon$2 akka.actor.ActorRef ), $anonfun$receive$2(scala.runtime.BoxedUnit ), $anonfun$receive$3(akka.stream.BindFailedException java.lang.Throwable ), $anonfun$connectionFor$1(akka.stream.impl.io.ConnectionSourceStage$$anon$2 akka.NotUsed )}, serializedLambda);
            }
        };
        return new Tuple2((Object)logic, (Object)bindingPromise.future());
    }

    public ConnectionSourceStage(ActorRef tcpManager, InetSocketAddress endpoint, int backlog, Traversable<Inet.SocketOption> options, boolean halfClose, Duration idleTimeout, FiniteDuration bindShutdownTimeout, IOSettings ioSettings) {
        this.tcpManager = tcpManager;
        this.endpoint = endpoint;
        this.backlog = backlog;
        this.options = options;
        this.halfClose = halfClose;
        this.idleTimeout = idleTimeout;
        this.bindShutdownTimeout = bindShutdownTimeout;
        this.ioSettings = ioSettings;
        this.out = Outlet$.MODULE$.apply("IncomingConnections.out");
        this.shape = new SourceShape<Tcp.IncomingConnection>(this.out());
    }
}

