/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.jsonstreaming;

import com.xebialabs.agatha.jsonstreaming.RegexpConsumer;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.regex.Matcher;

public class RegexpHandler {
    private final Matcher matcher;
    private final RegexpConsumer fn;
    private final int groupToTrackPosition;
    private int lastAcceptedPosition = -1;

    public RegexpHandler(Matcher matcher, int groupToTrackPosition, RegexpConsumer fn) {
        this.matcher = matcher;
        this.fn = fn;
        this.groupToTrackPosition = groupToTrackPosition;
    }

    public void onDataWindow(char[] buf, int off, int len, int position, boolean isFirst, boolean isFinish) throws IOException {
        if (isFirst) {
            this.lastAcceptedPosition = -1;
        }
        this.matcher.reset(CharBuffer.wrap(buf, off, len));
        while (this.matcher.find()) {
            int start = position + this.matcher.start(this.groupToTrackPosition);
            if (start <= this.lastAcceptedPosition || !this.fn.accept(this.matcher, start, isFirst, isFinish)) continue;
            this.lastAcceptedPosition = start;
        }
    }
}

